###################################################################################
#  Name: Nexus Published Artifact Trigger
#
#  Description: Trigger new release when new version of artifact is published to the Sonatype Nexus repository
#  Implementation:
#       Pull Nexus REST API to resolve an artifact identified by GAV coordinates given, and retrieve a set of details about that artifact.
#       Detected version (version and snapshotBuildNumber for snapshots) is stored into the triggerState and output variable.
#       REST API documentation: https://oss.sonatype.org/nexus-restlet1x-plugin/default/docs/path__artifact_maven_resolve.html
###################################################################################
import sys, urllib
import com.xhaus.jyson.JysonCodec as json
from nexus.NexusV3Script import NexusV3

print "----- Nexus XLR trigger poll started. -----\r\n"

# defaults to server 2
serverV3 = False

if (server['serverVersion'] == "Nexus v3+"):
    serverV3 = True

if serverV3:
    print "Nexus server: version 3+."
    RESOLVE_PATH = 'service/rest/v1/search'
    RESOLVE_PARAMETERS = {
        'repository': repositoryId,
        'maven.groupId': groupId,
        'maven.artifactId': artifactId,
        'maven.baseVersion': version if version != 'LATEST' and version != 'RELEASE' else '',
        'maven.classifier': classifier,
        'maven.extension': extension
    }
else:
    RESOLVE_PATH = 'service/local/artifact/maven/resolve'
    RESOLVE_PARAMETERS = {
        'r': repositoryId,
        'g': groupId,
        'a': artifactId,
        'v': version,
        'p': packaging,
        'c': classifier,
        'e': extension
    }

if server is None:
    print "No Nexus server provided."
    sys.exit(1)

if "*" in artifactId:
    raise Exception("Not allowed to use wildcards in Artifact Id: %s" % (artifactId))

if "*" in groupId:
    raise Exception("Not allowed to use wildcards in Group Id: %s" % (groupId))

request = HttpRequest(server, username, password)
params = dict((k, v) for k, v in RESOLVE_PARAMETERS.items() if v)
context = "%s?%s" % (RESOLVE_PATH, urllib.urlencode(params))
response = request.get(context, contentType='application/json')

if not response.isSuccessful():
    if response.status == 404 and triggerOnInitialPublish:
        print "Artifact '%s:%s:%s' not found in repository '%s'. Ignoring." % (
            groupId, artifactId, version, repositoryId)
        # the following initialisation is to enable a scenario where we wish
        # to trigger a release on a first publish of an artifact to Nexus
        if not triggerState:
            artifactVersion = triggerState = '0.0.0'
    else:
        print "Failed to fetch artifact metadata from Nexus repository %s" % server['url']
        response.errorDump()
        sys.exit(1)
else:
    resolution = json.loads(response.response)
    # nexus server v3
    if serverV3:
        if not resolution.get('items'):
            if not triggerState:
                print "Artifact '%s:%s:%s' not found in repository '%s'. Ignoring." % (
                    groupId, artifactId, version, repositoryId)
                artifactVersion = triggerState = '0.0.0'
        else:
            nexusV3 = NexusV3()

            finalResolution = nexusV3.processV3(request, context, resolution)

            if version == "" or version == "LATEST" or version == "RELEASE" or "*" in version or "-SNAPSHOT" in version:
                item = nexusV3.get_latest_item(finalResolution)
            else:
                # Otherwise, we assume it's present and in position [0]
                # (The code above is safe to use when a version number is specified, too)
                item = finalResolution.get('items')[0] if resolution.get('items')[0] else ''

            version = item['version'] if item['version'] else ''
            triggerState = version

            # populate output variables
            artifactVersion = version
            artifactRepositoryPath = str(item.get('assets')[0].get('path')) if item.get('assets')[0].get('path') else ''
            artifactDownloadUrl = str(item.get('assets')[0].get('downloadUrl')) if item.get('assets')[0].get('downloadUrl') else ''


    # nexus v2 and below
    else:
        data = resolution.get('data')
        version = str(data.get('version'))
        triggerState = version

        # populate output variables
        artifactVersion = version
        artifactBaseVersion = str(data.get('baseVersion')) if data.get('baseVersion') else version
        artifactSnapshotBuildNumber = str(data.get('snapshotBuildNumber')) if data.get('snapshotBuildNumber') else ''
        artifactRepositoryPath = str(data.get('repositoryPath')) if data.get('repositoryPath') else ''
