#
# Copyright 2025 XEBIALABS
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

from msteams.TeamsServer import TeamsServer
from msteams.util import validate_mandatory_field

msteams_client = TeamsServer.create_client(msteamsServer)
# Validate the mandatory fields
validate_mandatory_field(teamName, "Team name is not configured")
validate_mandatory_field(channelName, "Channel name is not configured")
validate_mandatory_field(message, "Message is not configured")
# Get the team details
team = msteams_client.list_teams(teamName)
#Get the team ID
team_id = team[0]['id']
# Get the channel details
channels = msteams_client.list_channels(team_id, channelName)
# Get the channel ID by channel name
channel_id = None
for channel in channels:
    if channel['displayName'] == channelName:
        channel_id = channel['id']
        break
# Send the message to the channel
response = msteams_client.send_message_to_channel(team_id, channel_id, message)
# Printing the message URL
print("[%s](%s)" % ("Message URL", response['webUrl']))
# Get the message ID (Output property)
messageId = response['id']