#
# Copyright 2025 XEBIALABS
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

from msteams.TeamsServer import TeamsServer
from msteams.util import validate_mandatory_field

msteams_client = TeamsServer.create_client(msteamsServer)
# Validate the mandatory fields
validate_mandatory_field(emailId, "Email ID is not configured")
validate_mandatory_field(message, "Message is not configured")
# Get the authorized user ID from connection
authorized_user_id = msteams_client.get_authorized_user_id()
# Get the recipient user ID from the user email ID
user_id = msteams_client.get_user_id(emailId)
# Create a chat with the user
chat_id = msteams_client.create_user_chat(authorized_user_id, user_id)
# Send the message to the user
response = msteams_client.send_message_to_chat(chat_id, message)
# Printing the message URL
message_url = 'https://teams.microsoft.com/l/message/{}/{}?context=%7B%22contextType%22%3A%22chat%22%7D'.format(chat_id, response['id'])
print("[%s](%s)" % ("Message URL", message_url))
# Get the message ID (Output property)
messageId = response['id']