from com.xebialabs.xlrelease.lookup.api.internal import LookupResultElement
from com.xebialabs.xlrelease.api.v1.filter import WorkflowFilters

DEFAULT_PAGE = 0
DEFAULT_RESULTS_PER_PAGE = 20
MAX_RESULTS_PER_PAGE = 200
MAX_DEPTH = 200

def _workflow_lookup(workflow_api, _ci, prop_name):
    filters = WorkflowFilters()
    filters.searchInput = _ci.getProperty(prop_name)
    filters.folderId = _ci.getProperty("folderId")
    result = workflow_api.searchWorkflows(filters, DEFAULT_PAGE, DEFAULT_RESULTS_PER_PAGE)

    return list(map(lambda (workflow): LookupResultElement(workflow.getTitle(), workflow.getId()), result.content))

