#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
import com.xebialabs.xlrelease.plugin.kubernetes.RemoteScript as RemoteScript
from kubernetes.api_client import APIClient
from org.apache.http.client import ClientProtocolException
from kubernetes.commandParams import CommandHelper

global configuration

response = None
try:
    client = APIClient(configuration._delegate.getProperty("host"), configuration.kubectlPath)

    flags = []
    commandline_params = ''

    flags = CommandHelper.commandParams(configuration, flags)

    command = "get pods %s" % (" ".join(flags) if flags else '')

    response = client.execute_command(command)
    if response.rc > 0:
        error_msg = response.stderr
        print "Command execution failed with error: %s" % error_msg
        raise RuntimeError("Command execution failed")

except ClientProtocolException:
    raise Exception("URL is not valid")
