#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys
import time
import re
from kubernetes.api_client import APIClient
from kubernetes.commandParams import CommandHelper

global configuration

command=task.pythonScript.getProperty('command')
pattern=task.pythonScript.getProperty('pattern')
wait_in_sec=task.pythonScript.getProperty('waitInSeconds')
retry_count=task.pythonScript.getProperty('retryCount')

flags = []
commandline_params = None
flags = CommandHelper.commandParams(kubectlConf, flags)

if flags or cmdParams:
    commandline_params = '%s %s' % (" ".join(flags) if flags else '', cmdParams if cmdParams else '')

client = APIClient(kubectlConf['host'], kubectlConf['kubectlPath'])
match=False
for num in range(0,retry_count):
    time.sleep(wait_in_sec)
    response = client.execute_command(command, commandline_params)
    output = response.stdout
    error = response.stderr
    if re.search(pattern,output,re.M):
        match=True
        break;

if not match and error:
    print error.split("\n")[-1]
    sys.exit(1)
else:
    if not match:
        raise Exception('Regular expression not found in command output')