#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
import oyaml as yaml
import re
from collections import OrderedDict
from yaml.dumper import Dumper
from yaml.representer import SafeRepresenter

class YamlParser:

    def __init__(self, file_path):
        self.file_path = file_path

    def replaceValue(self, path_value_map):

        result_data = []
        with open(self.file_path, "r") as file_content:
            yamlObjects = yaml.load_all(file_content, Loader=yaml.FullLoader)
            for yamlObject in yamlObjects:
                for path in path_value_map:
                    value = path_value_map[path]
                    pathElements = path.split("/")

                    pathLength = range(len(pathElements))
                    elementObj = yamlObject

                    for index in pathLength:
                        element = pathElements[index]
                        try:
                            if self.isConditionalOrArrayElement(element): # has cond expr {key:value} or [index] in path
                                tempElementObj = self.getElementObj(element, elementObj)
                                if type(tempElementObj) is list:
                                    elementObj = tempElementObj
                                    # loop through list elements and check if condn expr is satisfied
                                    elementObj = self.getArrayElement(element, elementObj)

                                elif type(tempElementObj) is dict or type(elementObj) is OrderedDict:
                                    # check if the condn expr {key1:val1, key2:val2, ..} is satisfied (in case of multi doc file)
                                    if self.isConnExprSatisfied(element, tempElementObj):
                                        elementObj = tempElementObj
                                    else:
                                        break
                            else:
                                if index == (len(pathElements) - 1):
                                    elementObj[element] = value
                                else:
                                    elementObj = elementObj[element]

                        except (KeyError, TypeError) as e:
                            print "Key Error: %s [Validate path or IGNORE if file has multiple documents]" % str(e)
                            break

                result_data.append(yamlObject)

        CustomDumper.add_representer(str, SafeRepresenter.represent_str)
        CustomDumper.add_representer(unicode, SafeRepresenter.represent_unicode)

        with open(self.file_path, 'w') as fp:
            yaml.dump_all(result_data, fp, Dumper=CustomDumper)

        return result_data

    def isConditionalOrArrayElement(self, pathElement):
        return re.search(r"\[(.+?)\]", pathElement) or re.search(r"\{(.+?)\}", pathElement)

    def getElementObj(self, pathElement, object):
        if re.search(r"\[(.+?)\]", pathElement):
            arrayPath = pathElement.split("[")[0]
        elif re.search(r"\{(.+?)\}", pathElement):
            arrayPath = pathElement.split("{")[0]

        object = object[arrayPath]
        return object

    def getArrayElement(self, pathElement, object):
        elementObject = None
        if re.search(r"\[(.+?)\]", pathElement):
            pattern = re.compile(r"\[(.+?)\]")
            index = int(pattern.findall(pathElement)[0])
            elementObject = object[index]

        elif re.search(r"\{(.+?)\}", pathElement):
            for objElement in object:
                condnExprSatisfied = self.isConnExprSatisfied(pathElement, objElement)
                if condnExprSatisfied:
                    elementObject = objElement
                    break

        return elementObject

    def isConnExprSatisfied(self, pathElement, objElement):
        pattern = re.compile(r"\{(.+?)\}")
        attrList = pattern.findall(pathElement)[0].split(",")
        mismatch = False

        for attr in attrList:
            if "~" in attr:
                kv = attr.split("~")
                key = kv[0]
                value = kv[1]

                if type(objElement) is dict or type(objElement) is OrderedDict:
                    if objElement[key] != value:
                        mismatch = True
                        break
                else:
                    mismatch = True
                    break
            else:
                mismatch = True
                break

        return not mismatch

class CustomDumper(Dumper):
    pass
