#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from kubernetes.api_client import APIClient
from kubernetes.commandParams import CommandHelper

if not task.pythonScript.getProperty('spec')  and not task.pythonScript.getProperty('url'):
    raise Exception('No source for input file (inline|URL) is provided')
elif task.pythonScript.getProperty('spec')  and task.pythonScript.getProperty('url'):
    raise Exception('Please provide only one source for input file(inline|url)')

host = kubectlConf["host"]

flags = []
commandline_params = None
flags = CommandHelper.commandParams(kubectlConf, flags)

if flags or cmdParams:
    commandline_params = '%s %s' % (" ".join(flags) if flags else '', cmdParams if cmdParams else '')

client = APIClient(kubectlConf['host'], kubectlConf['kubectlPath'])

spec = task.pythonScript.getProperty('spec')
if not spec:
    spec = APIClient.download_file(task.pythonScript.getProperty('url'),task.pythonScript.getProperty('username'),task.pythonScript.getProperty('password'))

response = client.execute_kubernetes_spec(spec,task.pythonScript.getProperty('command'), commandline_params)
