import sys, string
import com.xhaus.jyson.JysonCodec as json

ISSUE_CREATED_STATUS = 201

content = """
{
    "fields": {
       "project":
       {
          "key": "%s"
       },
       "summary": "%s",
       "description": "%s",
       "issuetype": {
          "name": "%s"
       }
   }
}
""" % (project, title, description, string.capwords(issueType))

if jiraServer is None:
    print "No server provided."
    sys.exit(1)

jiraURL = jiraServer['url']
if jiraURL.endswith('/'):
    jiraURL = jiraURL[:len(jiraURL)-1]

credentials = CredentialsFallback(jiraServer, username, password).getCredentials()

response = XLRequest(jiraURL + '/rest/api/2/issue', 'POST', content, credentials['username'], credentials['password'], 'application/json').send()

if response.status == ISSUE_CREATED_STATUS:
    data = json.loads(response.read())
    issueId = data.get('key')
    print "Created %s in JIRA at %s." % (issueId, jiraURL)
else:
    print "Failed to create issue in JIRA at %s." % jiraURL
    response.errorDump()
    sys.exit(1)
