#
# Copyright (c) 2022. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

import sets
import json
from xlrelease.HttpRequest import HttpRequest

HTTP_SUCCESS = sets.Set([200, 201, 204])


class JfrogClient:

    def __init__(self, server, username=None, password=None):
        if username and password:
            server['username'] = username;
            server['password'] = password;
        self.httpRequest = HttpRequest(server, verify=False)
        self.header = {"Accept": "*/*", "Content-Type": "application/json"}


    def getRepositories(self):
        url = '/artifactory/api/repositories'
        response = self.httpRequest.get(context=url, headers=self.header)
        return self.get_results(response, False)

    def findArtifactVersion(self, repositoryId, groupId, artifactId, version):
        url = '/artifactory/api/search/versions?g='+groupId+'&a='+artifactId+'&repos='+repositoryId+'&v=*'+version
        response = self.httpRequest.get(context=url, headers=self.header)
        return self.get_results(response, False)

    def findLatestVersion(self, repositoryId, groupId, artifactId, version):
        url = '/artifactory/api/search/latestVersion?g='+groupId+'&a='+artifactId+'&repos='+repositoryId+'&v='+version
        response = self.httpRequest.get(context=url, headers=self.header)
        return self.get_results(response, True)

    def getAllTags(self, repositoryId, imageName):
        url = '/artifactory/api/docker/'+repositoryId+'/v2/'+imageName+'/tags/list'
        response = self.httpRequest.get(context=url, headers=self.header)
        return self.get_results(response, False)

    def get_results(self, response, isString):
        if response.getStatus() in HTTP_SUCCESS:
            if response.getResponse() is not None:
                if isString:
                    response.getResponse()
                else:
                    return json.loads(response.getResponse())
        else:
            raise Exception(
                "Error from server, HTTP Return: %s, content %s" % (response.getStatus(), response.getResponse()))
