import sys
import urllib
from com.xebialabs.xlrelease.plugin.webhook import JsonPathResult
from com.xebialabs.xlrelease.reports.excel import ExcelSheetWriter
from java.io import IOException
from java.lang import RuntimeException
from java.util import Date
from org.joda.time import Duration
from org.joda.time import PeriodType

import json


def addBuildFacet(response):
    buildData = json.loads(response)
    displayName = buildData.get('displayName', '')
    fullDisplayName = buildData.get('fullDisplayName', '')
    facet = facetApi.newFacet("udm.BuildFacet")
    facet.targetId = task.id
    facet.project = fullDisplayName.replace(' {}'.format(displayName), '')
    facet.build = 'Build ' + displayName
    facet.build_url = buildData.get('url')
    facet.serverUrl = jenkinsServer['url']
    facet.serverUser = username or jenkinsServer['username']
    facet.outcome = buildData.get('result', None)
    facet.startDate = Date(long(buildData.get('timestamp')))
    facet.endDate = Date(long(buildData.get('timestamp') + buildData.get('duration')))
    facet.duration = ExcelSheetWriter.PERIOD_FORMATTER.print(Duration.millis(buildData.get('duration')).toPeriod().normalizedStandard(PeriodType.dayTime()))

    facetApi.createFacet(facet)


def finishPolling(buildStatus):
    print "\nFinished: %s" % buildStatus
    jenkinsJobURL = jenkinsURL + jobContext + str(buildNumber)
    task.setStatusLine("[Build #%s](%s)" % (str(buildNumber), jenkinsJobURL))
    if buildStatus != 'SUCCESS':
        sys.exit(1)


jenkinsURL = jenkinsServer['url']
jobUrl = jenkinsURL

request = HttpRequest(jenkinsServer, username, password)
jobContext = '/job/' + urllib.quote(jobName) + '/'

response = None
buildStatus = None
try:
    response = request.get(jobContext + str(buildNumber) + '/api/json', contentType='application/json')
    if response.isSuccessful():
        buildStatus = JsonPathResult(response.response, 'result').get()
        duration = JsonPathResult(response.response, 'duration').get()
        if buildStatus and duration != 0:
            try:
                addBuildFacet(response.response)
            except RuntimeException as e:
                print "\nCould not add 'Build' attribute: %s\n" % str(e)
            except Exception as e:
                print "\nCould not add 'Build' attribute: %s\n" % str(e)
            finishPolling(buildStatus)
        else:
            task.schedule("jenkins/Build.wait-for-build.py")
    else:
        print "\nFailed to check the job status. Received an error from the Jenkins server: `%s`" % response.response
        task.schedule("jenkins/Build.wait-for-build.py")

except IOException as error:
    print "\nFailed to check the job status due to connection problems. Will retry in the next polling run. Error details: `%s`" % error
    task.schedule("jenkins/Build.wait-for-build.py")
