import sys
import urllib
from com.xebialabs.xlrelease.plugin.webhook import JsonPathResult
from java.io import IOException


def finishPolling(buildStatus):
    print "\nFinished: %s" % buildStatus
    jenkinsJobURL = jenkinsURL + jobContext + str(buildNumber)
    task.setStatusLine("[Build #%s](%s)" % (str(buildNumber), jenkinsJobURL))
    if buildStatus != 'SUCCESS':
        sys.exit(1)

jenkinsURL = jenkinsServer['url']
jobUrl = jenkinsURL

request = HttpRequest(jenkinsServer, username, password)
jobContext = '/job/' + urllib.quote(jobName) + '/'

response = None
buildStatus = None
try:
    response = request.get(jobContext + str(buildNumber) + '/api/json', contentType='application/json')
    if response.isSuccessful():
        buildStatus = JsonPathResult(response.response, 'result').get()
        duration = JsonPathResult(response.response, 'duration').get()
        if buildStatus and duration != 0:
            finishPolling(buildStatus)
        else:
            task.schedule("jenkins/Build.wait-for-build.py")
    else:
        print "\nFailed to check the job status. Received an error from the Jenkins server: `%s`" % response.response
        task.schedule("jenkins/Build.wait-for-build.py")

except IOException as error:
    print "\nFailed to check the job status due to connection problems. Will retry in the next polling run. Error details: `%s`" % error
    task.schedule("jenkins/Build.wait-for-build.py")
