from jenkins import JenkinsServer
from jenkins.oidc_helper import OidcHelper

CONTENT_TYPE='application/json'
jenkinsURL = configuration['url']
jobContext = '/api/json'

connection_parameters = {'url': configuration.url, 
          'username': configuration.username, 
          'password': configuration.password,
          'apiToken':configuration.apiToken, 
          'proxyHost': configuration.proxyHost, 
          'proxyPort': configuration.proxyPort,
          'proxyUsername': configuration.proxyUsername, 
          'proxyPassword': configuration.proxyPassword,
          'proxyDomain': configuration.proxyDomain, 
        }

jenkins = JenkinsServer(connection_parameters, configuration.username, configuration.password, configuration.apiToken)

# Do http request
request = jenkins.create_request()
# Headers for CSRF Protection and apiToken based authentication
headers = jenkins.create_api_token_header(request)

if configuration.useOidc:
    #oidc parameters
    connection_parameters.update({
          'useOidc': configuration.useOidc,
          'oidcIssuerUrl': configuration.oidcIssuerUrl, 
          'oidcClientSecret': configuration.oidcClientSecret,
          'oidcClientIdOrEmail': configuration.oidcClientIdOrEmail,
          'oidcPrivateKey': configuration.oidcPrivateKey, 
          'oidcPrivateKeyId': configuration.oidcPrivateKeyId,
          'oidcRefreshToken': configuration.oidcRefreshToken,
          'oidcScope': configuration.oidcScope,         
          'oidcTokenHeaderName': configuration.oidcTokenHeaderName,
          'accessTokenHeaderName': configuration.accessTokenHeaderName})
    
    logger.debug("OIDC token is enabled, setting OIDC token headers")
    OidcHelper(connection_parameters).set_token_headers(headers)

response = request.get(jobContext , contentType=CONTENT_TYPE, headers=headers)
if not response.getStatus() in [200, 201, 202]:
    raise Exception("Failed to connect at %s." % (str(response.getStatus())+ response.getResponse()))