import urllib
import sys
import json

from jenkins import JenkinsServer

jenkinsURL = jenkinsServer['url']

if jenkinsURL.endswith("/"):
    job = 'job/'
else:
    job = '/job/'

jobContext = job + urllib.quote(jobName) + '/'
contentType = 'application/json'
endpoint = jobContext + 'api/json/build?delay=0'

# Jenkins instance
jenkins = JenkinsServer(jenkinsServer, username, password, apiToken)
# Do http request
request = jenkins.create_request()
# Headers for CSRF protection and apiToken based authentication
headers = jenkins.create_api_token_header(request)

# To Check if the JOB is Multibranch Pipeline or NOT.
job_response = request.get(jobContext + 'api/json', contentType=contentType, headers=headers)
job_info = json.loads(job_response.response)
job_class = ""
if "_class" in job_info:
    job_class = job_info["_class"]
    if job_class  == "org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject":
        print(" ' {} ' is a MultiBranch Pipeline Job".format(jobName))
    else:
        raise Exception(" ' {} ' is not a Multibranch Pipeline Job.".format(jobName))
else:
    raise Exception(" ' {} ' Job not found.".format(jobName))

# Scan Multibranch Pipeline
response = request.post(endpoint, '', contentType=contentType, headers=headers)
response_obj = json.loads(response.response)

if response.isSuccessful():
    print "Multibranch Pipeline has been Scanned Successfully. Status Code: {}".format(response.status)

else:
    print("Failed to Scan Multibranch Pipeline. Status Code: {}".format(response.getStatus()))
    response.errorDump()
    sys.exit(1)
