import sys
import urllib
from com.xebialabs.xlrelease.plugin.webhook import JsonPathResult
from jenkins import JenkinsServer

"""
Print a nicely formatted build started message
"""
def notifyBuildStarted(jenkinsURL, jobContext, jobName, jobBuildNumber):
    if(branch != None and len(branch) > 0) : jobContext = jobContext+"/job/"+branch+"/"
    jenkinsJobURL = jenkinsURL + jobContext + str(jobBuildNumber)
    print "Started [%s #%s](%s) - view [Console Output](%s)" % (jobName, jobBuildNumber, jenkinsJobURL, jenkinsJobURL + '/console')
    task.setStatusLine("Running build #%s" % jobBuildNumber)
    task.schedule("jenkins/Build.wait-for-build.py")


jenkinsURL = jenkinsServer['url']
jobUrl = jenkinsURL
jobContext = '/job/' + urllib.quote(jobName) + '/'
# Jenkins instance
jenkins = JenkinsServer(jenkinsServer, username, password, apiToken)
# Do http request
request = jenkins.create_request()
# Headers for CSRF protection and apiToken based authentication
headers = jenkins.create_api_token_header(request)

if location:
    # check the response to make sure we have an item
    response = request.get(location + 'api/json', contentType = 'application/json', headers=headers)
    if response.isSuccessful():
        # if we have been given a build number this item is no longer in the queue but is being built
        buildNumber = JsonPathResult(response.response, 'executable.number').get()
        if buildNumber:
            notifyBuildStarted(jenkinsURL, jobContext, jobName, buildNumber)
        else:
            task.schedule("jenkins/Build.wait-for-queue.py")

    else:
        print "Could not determine build number for queued build at %s." % (jenkinsURL + location + 'api/json')
        sys.exit(1)

else:
    # fallback to the unreliable check because old jenkins(<1.561) does not populate the Location header
    response = request.get(jobContext + 'api/json', contentType = 'application/json', headers=headers)
    # response.inQueue is a boolean set to True if a job has been queued
    inQueue = JsonPathResult(response.response, 'inQueue').get()
    if inQueue:
        task.schedule("jenkins/Build.wait-for-queue.py")
    else:
        buildNumber = JsonPathResult(response.response, 'lastBuild.number').get()
        notifyBuildStarted(jenkinsURL, jobContext, jobName, buildNumber)
