from org.apache.http.client import ClientProtocolException
from base64 import b64encode

# HTTP connection check with jenkins server
params = {'url': configuration.url, 'proxyHost': configuration.proxyHost, 'proxyPort': configuration.proxyPort,
          'proxyUsername': configuration.proxyUsername, 'proxyPassword': configuration.proxyPassword}

path = configuration.checkConfigurationPath
response = None
try:
    headers = None

    # Connection using username/apiToken
    if configuration.apiToken:
        auth = b64encode('%s:%s' % (configuration.username, configuration.apiToken))
        headers = {'Authorization': 'Basic %s' % auth}

    # Connection using username/password
    elif configuration.password:
        params['username'] = configuration.username
        params['password'] = configuration.password
    response = HttpRequest(params).get(path + '/application-properties',
                                       contentType='application/json', headers=headers)
except ClientProtocolException:
    raise Exception("URL is not valid")

# In case of response failure
if not response.isSuccessful():
    reason = "Unknown"
    if response.status == 400:
        reason = "Bad request"
    elif response.status == 401:
        reason = "Unauthorized"
    elif response.status == 403:
        reason = "Forbidden"
    raise Exception("HTTP response code %s (%s)" % (response.status, reason))