import sys
import urllib

from com.xebialabs.xlrelease.plugin.webhook import JsonPathResult
from jenkins import JenkinsServer

"""
Calls Jenkins API in order to know if a job expects parameters
When expecting a parameter named "param", the JSON looks like:

    "actions" : [
        {
            "parameterDefinitions" : [
                {
                    "defaultParameterValue" : {
                        "name" : "param",
                        "value" : ""
                    },
                    "description" : "",
                    "name" : "param",
                    "type" : "StringParameterDefinition"
                }
            ]
        }
    ]

In last versions of Jenkins the parameters are defined in "property" field, leaving "actions" for old versions
"""
def isJobParameterized(request, jobContext, headers):
    jobInfo = request.get(jobContext + 'api/json', contentType='application/json', headers=headers)
    jobProperties = JsonPathResult(jobInfo.response, 'property').get()
    if jobProperties is not None:
        for prop in jobProperties:
            if (prop is not None and 'parameterDefinitions' in prop):
                return True

    jobActions = JsonPathResult(jobInfo.response, 'actions').get()
    if jobActions is not None:
        for action in jobActions:
            if (action is not None and 'parameterDefinitions' in action):
                return True

    return False

"""
With an input that looks like:
param1=value 1\n
param2=value 2\n

Produces: ?param1=value%201&param2=value%202 to be used as a query string
"""
def buildQueryString(params):
    if (params is not None):
        queryParams = []
        for param in params.splitlines():
            if param:
                tokens = param.split('=', 1)
                queryParams.append(tokens[0] + "=" + urllib.quote(tokens[1]))
        return "?" + "&".join(queryParams)
    else:
        return ""

if jenkinsServer is None:
    print "No server provided."
    sys.exit(1)

jenkinsURL = jenkinsServer['url']
jobContext = '/job/' + urllib.quote(jobName) + '/'

# Jenkins instance
jenkins = JenkinsServer(jenkinsServer, username, password, apiToken)
# Do http request
request = jenkins.create_request()
# Headers for CSRF Protection and apiToken based authentication
headers = jenkins.create_api_token_header(request)

response = request.get(jobContext + 'api/json', contentType='application/json', headers=headers)

if response.isSuccessful():
    jobClass = JsonPathResult(response.response, '_class').get()

    if "WorkflowMultiBranchProject" in jobClass:

        jobs = JsonPathResult(response.response, 'jobs').get()
        for job in jobs:
            if job['name'] == branch:
                jobUrl = job['url']

        jobUrl = jobUrl.replace(jenkinsURL, '')
        buildContext = jobUrl.replace(jenkinsURL, '')

    if isJobParameterized(request, jobContext, headers):
        buildContext = jobContext + 'buildWithParameters' + buildQueryString(jobParameters)
    else:
        buildContext = jobContext + 'build'

    if "WorkflowMultiBranchProject" in jobClass:
        buildContext = jobContext + 'job/' + branch + '/build'

    buildResponse = request.post(buildContext, '', contentType='application/json', headers=headers)
    print ("Build response from jenkins is %s " % buildResponse.getStatus())

    if not buildResponse.getStatus() in [200, 201, 202]:
        print ("Unable to create the build request. Please check the parameters and job name.")
        print (buildResponse.getStatus())
        print (buildResponse.getHeaders())
        print (buildResponse.response)
        sys.exit(1)

    # query the location header which gives a queue item position (more reliable for retrieving the correct job later)
    location = None
    if 'Location' in buildResponse.getHeaders() and '/queue/item/' in buildResponse.getHeaders()['Location']:
        location = '/queue/item/' + filter(None, buildResponse.getHeaders()['Location'].split('/'))[-1] + '/'

    task.setStatusLine("Build queued")
    task.schedule("jenkins/Build.wait-for-queue.py")
else:
    print "Failed to connect at %s." % (jenkinsURL + jobContext)
    response.errorDump()
    sys.exit(1)