import sys
import urllib
from com.xebialabs.xlrelease.plugin.webhook import JsonPathResult
from com.xebialabs.xlrelease.reports.excel import ExcelSheetWriter
from java.io import IOException
from java.lang import RuntimeException
from java.util import Date
from org.joda.time import Duration
from org.joda.time import PeriodType
from jenkins import JenkinsServer

import json


def addBuildRecord(response):
    buildData = json.loads(response)
    displayName = buildData.get('displayName', '')
    fullDisplayName = buildData.get('fullDisplayName', '')
    buildRecord = taskReportingApi.newBuildRecord()
    buildRecord.targetId = task.id
    buildRecord.project = fullDisplayName.replace(' {}'.format(displayName), '')
    buildRecord.build = 'Build ' + displayName
    buildRecord.build_url = buildData.get('url')
    buildRecord.serverUrl = jenkinsServer['url']
    buildRecord.serverUser = username or jenkinsServer['username']
    buildRecord.outcome = buildData.get('result', None)
    buildRecord.startDate = Date(long(buildData.get('timestamp')))
    buildRecord.endDate = Date(long(buildData.get('timestamp') + buildData.get('duration')))
    buildRecord.duration = ExcelSheetWriter.PERIOD_FORMATTER.print(Duration.millis(buildData.get('duration')).toPeriod().normalizedStandard(PeriodType.dayTime()))

    taskReportingApi.addRecord(buildRecord, True)


def finishPolling(buildStatus):
    print "\nFinished: %s" % buildStatus
    jenkinsJobURL = jenkinsURL + jobContext + str(buildNumber)
    task.setStatusLine("[Build #%s](%s)" % (str(buildNumber), jenkinsJobURL))
    if buildStatus != 'SUCCESS':
        task.schedule("jenkins/Build.fail.py")


jenkinsURL = jenkinsServer['url']
jobUrl = jenkinsURL
jobPath = "/job/"

# Jenkins instance
jenkins = JenkinsServer(jenkinsServer, username, password, apiToken)
# Do http request
request = jenkins.create_request()
# Headers for CSRF protection and apiToken based authentication
headers = jenkins.create_api_token_header(request)
jobContext = jobPath + urllib.quote(jobName) + '/'

response = None
buildStatus = None
try:
    response = request.get(jobContext + str(buildNumber) + '/api/json', contentType='application/json', headers=headers)
    # if the request is for multibranch pipeline then create the appropriate url
    if not response.isSuccessful():
        jobContext = jobPath + urllib.quote(jobName) + jobPath + branch + "/"
        response = request.get(jobContext + str(buildNumber) + '/api/json', contentType='application/json', headers=headers)

    if response.isSuccessful():
        buildStatus = JsonPathResult(response.response, 'result').get()
        duration = JsonPathResult(response.response, 'duration').get()
        if buildStatus and duration != 0:
            try:
                addBuildRecord(response.response)
            except RuntimeException as e:
                print "\nCould not add 'Build' attribute: %s\n" % str(e)
            except Exception as e:
                print "\nCould not add 'Build' attribute: %s\n" % str(e)
            finishPolling(buildStatus)
        else:
            task.schedule("jenkins/Build.wait-for-build.py")
    else:
        print "\nFailed to check the job status. Received an error from the Jenkins server: `%s`" % response.response
        task.schedule("jenkins/Build.wait-for-build.py")

except IOException as error:
    print "\nFailed to check the job status due to connection problems. Will retry in the next polling run. Error details: `%s`" % error
    task.schedule("jenkins/Build.wait-for-build.py")
