# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.


from gitlab.Client import Client

import json


def findNewCommit(oldCommitMap, newCommitMap):
    branch = ""
    commitId = ""

    # loop over new map branches
    for newBranch, newCommitId in newCommitMap.iteritems():
        # check if branch exists in old map
        if newBranch in oldCommitMap:
            oldCommitId = oldCommitMap[newBranch]
            # compare commit ids
            if newCommitId != oldCommitId:
                branch = newBranch
                commitId = newCommitId
                break
        else:
            # new branch, this triggered it
            branch = newBranch
            commitId = newCommitId
            break

    return branch, commitId


if gitlab_server is None:
    raise Exception("No GitLab server provided.")

client = Client()
latestCommits = client.gitlab_branch_statuses(locals())

# trigger state is persisted as json
newTriggerState = json.dumps(latestCommits)

if triggerState != latestCommits:
    if len(triggerState) == 0:
        oldCommits = {}
    else:
        oldCommits = json.loads(triggerState)

    branch, commitId = findNewCommit(oldCommits, latestCommits)

    if not branchName or (branchName and branchName == branch):
        triggerState = newTriggerState

print("GitLab triggered release for %s %s" % (branch, commitId))
