#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

from fortify import FortifyService

global securityApi, response, configurationApi, request

fortify_server = securityApi.decrypt(configurationApi.getConfiguration(request.query['fortifyServerId']))

params = {'url': fortify_server.url, 'username': fortify_server.username, 'password': fortify_server.password,
          'proxyHost': fortify_server.proxyHost, 'proxyPort': fortify_server.proxyPort,
          'proxyUsername': fortify_server.proxyUsername, 'proxyPassword': fortify_server.proxyPassword}

metrics = FortifyService.get_performance_indicators(params)

result = []
for metric in metrics:
    result.append({
        'id': str(metric['id']),
        'guid': metric['guid'],
        'title': metric['name'],
        'range': metric['range']
    })
response.entity = result
