#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

import json

from java.util.concurrent import Callable

from fortify import FortifyService


class GetVersionVulnerabilitiesTask(Callable):
    def __init__(self, fortify_server, version_id, standards):
        self.fortify_server = fortify_server
        self.version_id = version_id
        self.standards = standards
        self.result = None
        self.exception = None

    def call(self):
        try:
            response = FortifyService.get_vulnerabilities(self.fortify_server, self.version_id, self.standards)
            result = {}
            for idx, issue in enumerate(response.get('data')):
                security_uuid, security_name = self.standards[idx].split(':')
                for bulk_response in issue.get('responses'):
                    if bulk_response.get('body').get('responseCode') != 200:
                        raise Exception('Error occurred while fetching {} standard,  body={}'.format(security_name, json.dumps(response.get('body'))))

                    result[security_uuid] = []
                    for vulnerability in bulk_response.get('body', {}).get('data', []):
                        if vulnerability.get('cleanName') != '[NONE]':
                            result[security_uuid].append({
                                'value': vulnerability.get('cleanName'),
                                'count': vulnerability.get('totalCount')
                            })

            self.result = result
        except Exception as ex:
            self.exception = ex
        return self
