#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

from fortify import FortifyService

FORTIFY_SECURITY_RATING = 'FortifySecurityRating'

if not fortifyServer:
    raise Exception("Fortify server ID must be provided")

project_versions = FortifyService.get_project_versions(fortifyServer, project_name=projectName)

project = None
for project_version in project_versions.get('data'):
    if project_version.get('name') == projectVersion:
        project = project_version
        break

if project is None:
    raise Exception("Project with name '{}' and version '{}' not found".format(projectName, projectVersion))

rating = FortifyService.get_fortify_performance_indicator_histories(fortifyServer, version_id=project.get('id'),
                                                                    indicator=FORTIFY_SECURITY_RATING)
print "Analysis Date and Time: {}".format(rating['timestamp'])
FortifyService.add_comment("Fortify Security Rating : {}".format(rating['value']))
FortifyService.add_comment("Minimum Security Rating: {}".format(minimumStarRating))
if rating['value'] < minimumStarRating:
    raise Exception("Code compliance check(s) failed")

print "Code compliance checks verified."
