/*
 * Copyright (c) 2018. All rights reserved.
 *
 * This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
 */
'use strict';

(function () {

    var FortifyQueryTileViewController = function ($scope, FortifyQueryService, XlrTileHelper) {
        var vm = this;

        vm.tileConfigurationIsPopulated = tileConfigurationIsPopulated;

        var tile;

        if ($scope.xlrDashboard) {
            // summary page
            vm.release = $scope.xlrDashboard.release;
            vm.tile = $scope.xlrTile.tile;
            if (vm.tile.properties == null) {
                vm.config = vm.tile.configurationProperties;
            } else {
                // new style since 7.0
                vm.config = vm.tile.properties;
            }
        }

        function tileConfigurationIsPopulated() {
            return !_.isEmpty(vm.config.fortifyServer);
        }

        $scope.filterByKey = function (item) {
            return (item.key != 'Project Name' && item.key != 'Project Version' && item.key != 'Last measured on');
        };

        function load(config) {
            if (tileConfigurationIsPopulated()) {
                vm.loading = true;
                FortifyQueryService.executeQuery(vm.tile.id, config).then(
                    function (response) {
                        var fortifydata = response.data.data;
                        var lstData = [];
                        if (!fortifydata.error) {
                            for (var metric = 0 ; metric < Object.getOwnPropertyNames(fortifydata).length ; metric++)
                            {
                                var keyName = Object.getOwnPropertyNames(fortifydata)[metric];
                                var finalKeyName = vm.config.metrics.value[keyName];
                                switch(keyName){
                                    case 'id' : break;
                                    case 'versionId': break;
                                    case 'projectName': lstData.push({key : 'Project Name', value : fortifydata[keyName], url : fortifydata['fortifyUrl'] + '/html/ssc/version/' + fortifydata['versionId'] + '/overview'}); break;
                                    case 'projectVersion': lstData.push({key : 'Project Version', value : fortifydata[keyName], url : fortifydata['fortifyUrl'] + '/html/ssc/version/' + fortifydata['versionId'] + '/overview'}); break;
                                    case 'fortifyUrl' : break;
                                    case 'lastAnalysisDate': lstData.push({key : 'Last measured on', value : fortifydata[keyName]}); break;
                                    default : lstData.push({ key : finalKeyName, value : fortifydata[keyName], url : fortifydata['fortifyUrl'] + '/html/ssc/version/'+ fortifydata['versionId'] + '/fix'});

                                }

                            }
                            vm.result = {'lstData':lstData};
                        }else{
                            var error=''
                            if(fortifydata.error instanceof Array){
                                for (var index = 0 ; index < fortifydata.error.length ; index++){
                                    error=error+ fortifydata.error[index]['msg']
                                }
                            }else{
                                error=fortifydata.error
                            }
                            vm.result = {'lstData':lstData, 'error':error};
                        }

                        $scope.xlrTile.title = tile.title + " : " + fortifydata['name'];
                    }
                ).finally(function () {
                    vm.loading = false;

                });
            }
        }


        function refresh() {
            load({params: {refresh: true}});
        }

        load();

        vm.refresh = refresh;
    };

    FortifyQueryTileViewController.$inject = ['$scope', 'xlrelease.fortify.FortifyQueryService', 'XlrTileHelper'];

    var FortifyQueryService = function (Backend) {

        function executeQuery(tileId, config) {
            return Backend.get("tiles/" + tileId + "/data", config);
        }

        return {
            executeQuery: executeQuery
        };
    };

    FortifyQueryService.$inject = ['Backend'];

    angular.module('xlrelease.fortify.tile', []);
    angular.module('xlrelease.fortify.tile').service('xlrelease.fortify.FortifyQueryService', FortifyQueryService);
    angular.module('xlrelease.fortify.tile').controller('fortify.FortifyQueryTileViewController', FortifyQueryTileViewController);
    angular.module('xlrelease').directive("addScrollBar",function(){return{
            link:function(scope,element){
                element.context.parentElement.style.overflowY = "auto";
            }}});

})();

