#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import org.apache.http.conn.HttpHostConnectException

from fortify import FortifyService

if not fortifyServer:
    raise Exception("Fortify server ID must be provided")
try:
    version_id = FortifyService.get_project_version(fortifyServer, project_name=projectName, project_version=projectVersion)['id']

    metrics_data = FortifyService.get_fortify_performance_indicator_histories(fortify_server=fortifyServer,
                                                                              version_id=version_id)
    data_map = {item['id']: item for item in metrics_data}
    data = {'projectName': projectName, 'projectVersion': projectVersion, 'versionId': version_id, 'fortifyUrl': fortifyServer['url'],
            'lastAnalysisDate': metrics_data[0]['timestamp'] if bool(metrics_data) and 'timestamp' in metrics_data[0] else '-'}

    for item in metrics.keys():
        if item in data_map and 'value' in data_map[item]:
            data[item] = str(data_map[item]['value']) + ('%' if data_map[item]['range'].lower() == 'percent' else '')
        else:
            data[item] = '-'

except org.apache.http.conn.HttpHostConnectException as e:
    print "Connection Failed: {0} ".format(str(e))
    data={'error': [{'msg': e.getMessage()}]}

except Exception as e:
    print "Exception occurred: {0} ".format(str(e))
    data={'error': [{'msg': str(e)}]}
