import json
from xlrelease.HttpRequest import HttpRequest
import urllib

PROJECT_VERSIONS_API_BASE = "api/v1/projectVersions"
API_BASE = "api/v1"


class FortifyService(object):
    metrics = {}

    @staticmethod
    def get_fortify_performance_indicator_histories(fortify_server, version_id, indicator=''):
        http_request = HttpRequest(fortify_server)
        fortify_response = http_request.get('{}/{}/performanceIndicatorHistories/{}'
                                            .format(PROJECT_VERSIONS_API_BASE, version_id, indicator))
        error_message = "Failed to get Fortify Measures. Server return [%s], with content [%s]" % (
            fortify_response.status, fortify_response.response)
        FortifyService.validate_response(error_message, fortify_response)
        return json.loads(fortify_response.getResponse())['data']

    @staticmethod
    def validate_response(error_message, fortify_response):
        if not fortify_response.isSuccessful():
            raise Exception(error_message)

    @staticmethod
    def get_project_version(fortify_server, project_name, project_version):
        query = urllib.quote_plus('project.name:"{}"'.format(project_name))
        fortify_server_api_url = "{}?q={}".format(PROJECT_VERSIONS_API_BASE, query)
        http_request = HttpRequest(fortify_server)
        fortify_response = http_request.get(fortify_server_api_url)
        FortifyService.validate_response("Failed to get Fortify Measures. Server return [%s], with content [%s]" % (
            fortify_response.status, fortify_response.response), fortify_response)
        all_versions = json.loads(fortify_response.getResponse())['data']
        for version in all_versions:
            if version['project']['name'] == project_name and version['name'] == project_version:
                return version

        raise Exception("Project with name '{}' and version '{}' not found".format(project_name, project_version))

    @staticmethod
    def get_performance_indicators(params):
        http_request = HttpRequest(params)
        fortify_response = http_request.get('{}/performanceIndicators'.format(API_BASE))
        error_message = "Failed to get Fortify performance indicators. Server returns [%s], with content [%s]" % (
            fortify_response.status, fortify_response.response)
        FortifyService.validate_response(error_message, fortify_response)
        return json.loads(fortify_response.getResponse())['data']

    @staticmethod
    def add_comment(comment):
        print "```"
        print comment
        print "```"

