from fortify import FortifyService

fortify_server = securityApi.decrypt(configurationApi.getConfiguration(request.query['serverId']))

params = {'url': fortify_server.url, 'username': fortify_server.username, 'password': fortify_server.password,
          'proxyHost': fortify_server.proxyHost, 'proxyPort': fortify_server.proxyPort,
          'proxyUsername': fortify_server.proxyUsername, 'proxyPassword': fortify_server.proxyPassword}

try:
    metrics = FortifyService.get_performance_indicators(params)
    result = {metric['guid']: metric['name'] + (' %' if metric['range'].lower() == 'percent' else '')
              for metric in metrics}
    response.entity = result
except Exception as e:
    print("Exception occurred: {}".format(str(e)))
    error = str(e)
    sys.exit(1)



