#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

from fortifyOnDemand import FortifyOnDemandService
from fortifyOnDemand.task import add_comment

global fortifyOnDemandServer, projectName, projectVersion, minimumStarRating

if not fortifyOnDemandServer:
    raise Exception("Fortify on Demand server ID must be provided")

application_data = FortifyOnDemandService.get_application_data(fortifyOnDemandServer, application_name=projectName)

total_count = application_data["totalCount"]
items = application_data["items"]

if total_count > 0 and items[0]["applicationName"] == projectName:
    release_rating_data = FortifyOnDemandService.get_release_ratings(fortifyOnDemandServer,
                                                                     application_id=items[0]["applicationId"],
                                                                     release_name=projectVersion)
    release_total_count = release_rating_data["totalCount"]
    release_items = release_rating_data["items"]

    if release_total_count > 0 and release_items[0]["releaseName"] == projectVersion:
        if release_items[0]["staticScanDate"] is not None:
            add_comment("Static Analysis Date and Time : {}".format(release_items[0]["staticScanDate"]))
        if release_items[0]["dynamicScanDate"] is not None:
            add_comment("Dynamic Analysis Date and Time : {}".format(release_items[0]["dynamicScanDate"]))
        if release_items[0]["mobileScanDate"] is not None:
            add_comment("Mobile Analysis Date and Time : {}".format(release_items[0]["mobileScanDate"]))
        add_comment("Fortify Security Rating : {}".format(release_items[0]["rating"]))
        add_comment("Minimum Security Rating: {}".format(minimumStarRating))
        if release_items[0]["rating"] < minimumStarRating:
            raise Exception("Code compliance check(s) failed")
        add_comment("Code compliance checks verified.")
    else:
        error_message = "Failed to get release data. Please verify Release Name : %s on server." % projectVersion
        raise Exception(error_message)
else:
    error_message = "Failed to get application data. Please verify Application Name : %s on server." % projectName
    raise Exception(error_message)
