#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#
import time

from fortifyOnDemand.client.FortifyOnDemandClient import FortifyOnDemandClient


class FortifyOnDemandClientUtil(object):
    auth_cache = {}

    @staticmethod
    def create_fortify_on_demand_client(container, token=None):
        client = FortifyOnDemandClient.create_client(container, token)
        return client

    @staticmethod
    def get_fortify_on_demand_client(fortify_server):
        params = FortifyOnDemandClientUtil.get_configuration(fortify_server)
        id = fortify_server['id']

        if id not in FortifyOnDemandClientUtil.auth_cache:
            FortifyOnDemandClientUtil.authenticate(id, params)
        elif FortifyOnDemandClientUtil.auth_cache[id]['access_token'] == "" or \
                FortifyOnDemandClientUtil.auth_cache[id]['token_expiry'] <= FortifyOnDemandClientUtil.get_current_time():
            FortifyOnDemandClientUtil.authenticate(id, params)

        return FortifyOnDemandClientUtil.create_fortify_on_demand_client(params, FortifyOnDemandClientUtil.auth_cache[id]['access_token'])

    @staticmethod
    def get_configuration(fortify_server):
        params = {'url': fortify_server.get('url'), 'username': fortify_server.get('username'),
                  'password': fortify_server.get('password'),
                  'proxyHost': fortify_server.get('proxyHost'), 'proxyPort': fortify_server.get('proxyPort')}
        return params

    @staticmethod
    def get_current_time():
        return long(round(time.time()))

    @staticmethod
    def get_access_token(params):
        fortify_on_demand_client = FortifyOnDemandClientUtil.create_fortify_on_demand_client(params)
        return fortify_on_demand_client.login()

    @staticmethod
    def authenticate(id, params):
        auth_data = FortifyOnDemandClientUtil.get_access_token(params)
        FortifyOnDemandClientUtil.auth_cache[id] = {
            'access_token': auth_data["access_token"],
            'token_expiry': auth_data["expires_in"] + FortifyOnDemandClientUtil.get_current_time()
        }
