/*
 * Copyright (c) 2018. All rights reserved.
 *
 * This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
 */
'use strict';

(function () {

    var FortifyOnDemandQueryTileViewController = function ($scope, FortifyOnDemandQueryService, XlrTileHelper) {
        var vm = this;

        vm.tileConfigurationIsPopulated = tileConfigurationIsPopulated;

        function tileConfigurationIsPopulated() {
            return !_.isEmpty(vm.config.fortifyOnDemandServer);
        }

        $scope.filterByKey = function (item) {
            return (item.key != 'Application Name' && item.key != 'Release'
                && item.key != 'Static Scan Date' && item.key != 'Dynamic Scan Date'
                && item.key != 'Mobile Scan Date' && item.key != ' Policy Compliance');
        };

        function load(config) {
            if (tileConfigurationIsPopulated()) {
                vm.loading = true;
                FortifyOnDemandQueryService.executeQuery(vm.tile.id, config).then(
                    function (response) {
                        var fortifydata = response.data.data;
                        var lstData = [];
                        if (!fortifydata.error) {
                            for (var metric = 0; metric < Object.getOwnPropertyNames(fortifydata).length; metric++) {
                                var keyName = Object.getOwnPropertyNames(fortifydata)[metric];
                                switch (keyName) {
                                    case 'projectName':
                                        break;
                                    case 'projectVersion':
                                        break;
                                    case 'fortifyUrl':
                                        break;
                                    case 'applicationId':
                                        lstData.push({
                                            key: 'Application Name',
                                            value: fortifydata['projectName'],
                                            url: fortifydata['fortifyUrl'] + '/Applications/' + fortifydata['applicationId']
                                        });
                                        break;
                                    case 'releaseId':
                                        lstData.push({
                                            key: 'Release',
                                            value: fortifydata['projectVersion'],
                                            url: fortifydata['fortifyUrl'] + '/Releases/' + fortifydata['releaseId'] + '/Overview'
                                        });
                                        break;
                                    case 'staticScanDate':
                                        lstData.push({key: 'Static Scan Date', value: fortifydata[keyName]});
                                        break;
                                    case 'dynamicScanDate':
                                        lstData.push({key: 'Dynamic Scan Date', value: fortifydata[keyName]});
                                        break;
                                    case 'mobileScanDate':
                                        lstData.push({key: 'Mobile Scan Date', value: fortifydata[keyName]});
                                        break;
                                    case 'rating':
                                        lstData.push({key: 'Policy Compliance', value: fortifydata[keyName]});
                                        break;
                                    default :
                                }
                            }
                            vm.result = {'lstData': lstData};

                            var categories = ['Low', 'Medium', 'High', 'Critical'];
                            var keys = ['low', 'medium', 'high', 'critical'];
                            var counts = [];
                            keys.forEach(function (key) {
                                counts.push(fortifydata[key]);
                            });
                            vm.riskReportBarChartData = createEchartOptions(categories, counts);
                        } else {
                            var error = ''
                            if (fortifydata.error instanceof Array) {
                                for (var index = 0; index < fortifydata.error.length; index++) {
                                    error = error + fortifydata.error[index]['msg']
                                }
                            } else {
                                error = fortifydata.error
                            }
                            vm.result = {'lstData': lstData, 'error': error};
                        }
                        $scope.xlrTile.title = vm.tile.title;
                    }
                ).finally(function () {
                    vm.loading = false;

                });
            }
        }

        function createEchartOptions(categories, counts) {
            var DEFAULT_MAX = 30;
            return {
                yAxis: {
                    type: 'category',
                    data: categories,
                    axisLine: {show: false},
                    axisTick: {show: false},
                    axisPointer: {show: false}
                },
                xAxis: {
                    show: false,
                    max: function () {
                        var valArray = counts.slice(0);
                        valArray.push(DEFAULT_MAX);
                        return Math.max(...valArray);
                    },
                    type: 'value',
                    axisLabel: {
                        show: false
                    }
                },
                series: [{
                    data: counts,
                    type: 'bar',
                    itemStyle: {
                        normal: {
                            color: function (params) {
                                var colorList = [
                                    '#fccc0a', '#f99c1c', '#f26527', '#e11f26'
                                ];
                                return colorList[params.dataIndex]
                            },
                            label: {
                                show: true,
                                position: 'right',
                                formatter: '{c}',
                                color: 'rgb(0,0,0)'
                            }
                        }
                    }
                }]
            };
        }


        function refresh() {
            load({params: {refresh: true}});
        }

        vm.$onInit = function () {
            if ($scope.xlrDashboard) {
                // summary page
                vm.release = $scope.xlrDashboard.release;
                vm.tile = $scope.xlrTile.tile;
                if (vm.tile.properties == null) {
                    vm.config = vm.tile.configurationProperties;
                } else {
                    // new style since 7.0
                    vm.config = vm.tile.properties;
                }
            }
            load();
        };

        vm.refresh = refresh;
    };

    FortifyOnDemandQueryTileViewController.$inject = ['$scope', 'xlrelease.fortifyOnDemand.FortifyOnDemandQueryService', 'XlrTileHelper'];

    var FortifyOnDemandQueryService = function (Backend) {

        function executeQuery(tileId, config) {
            return Backend.get("tiles/" + tileId + "/data", config);
        }

        return {
            executeQuery: executeQuery
        };
    };

    FortifyOnDemandQueryService.$inject = ['Backend'];

    angular.module('xlrelease.fortifyOnDemand.tile', []);
    angular.module('xlrelease.fortifyOnDemand.tile').service('xlrelease.fortifyOnDemand.FortifyOnDemandQueryService', FortifyOnDemandQueryService);
    angular.module('xlrelease.fortifyOnDemand.tile').controller('fortifyOnDemand.FortifyOnDemandQueryTileViewController', FortifyOnDemandQueryTileViewController);
    angular.module('xlrelease').directive("addScrollBar", function () {
        return {
            link: function (scope, element) {
                element.parent().css('overflowY', 'auto')
            }
        }
    });

})();

