/*
 * Copyright (c) 2018. All rights reserved.
 *
 * This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
 */
'use strict';

(function () {

    const xlrFortifyOnDemandDipOfInlineWithVariablesController = function ($scope, ConfigurationInstances, Backend, Ids) {
        const vm = this;

        vm.ConfigurationInstances = ConfigurationInstances;
        vm.Backend = Backend;
        vm.Ids = Ids;
        vm.onNewVariablePF = function (name, variableType, createdCallback) {
            vm.onNewVariable({
                name: name,
                variableType: variableType,
                createdCallback: createdCallback
            });
        };

        vm.$onInit = function () {
            vm.showRequiredSign = _.isUndefined(vm.showRequiredSign) || vm.showRequiredSign;
            if (!ConfigurationInstances.loaded()) {
                ConfigurationInstances.load();
            }
        };

        const selectOptions = {};
        vm.selectOptions = function (p) {
            if (_.isUndefined(selectOptions[p.name])) {
                selectOptions[p.name] = (p.required ? [] : [{
                    title: "(None)",
                    id: null
                }]).concat(ConfigurationInstances.getInstancesByType(p.referencedType));
            }
            return selectOptions[p.name];
        };
        ///

        $scope.$on('$destroy', function () {
            ConfigurationInstances.reset();
        });
    };

    xlrFortifyOnDemandDipOfInlineWithVariablesController.$inject = ['$scope', 'ConfigurationInstances', 'Backend', 'Ids'];
    angular.module('xlrelease').controller('xlrFortifyOnDemandDipOfInlineWithVariablesController', xlrFortifyOnDemandDipOfInlineWithVariablesController);
    angular.module('xlrelease').directive('xlrFortifyOnDemandDipOfInlineWithVariables', function () {
        return {
            scope: {
                propertyDefinitions: '=',
                propertyValues: '=',
                variables: '=',
                readOnly: '=',
                enforceMode: '=',
                showRequiredSign: '=?',
                // for task input properties of type text we don't use variable selector, for output properties we do
                showVariableSelectorForText: '=',
                onChange: '&',
                onNewVariable: '&'
            },
            restrict: 'AE',
            templateUrl: 'static/@project.version@/include/FortifyOnDemandSummaryTile/directives/xlr-fortify-on-demand-dip-of-inline-with-variables.html',
            controller: 'xlrFortifyOnDemandDipOfInlineWithVariablesController',
            controllerAs: 'xlrDipCtrl',
            bindToController: true
        };
    });

    //  directive for fortify list of enum div
    angular.module('xlrelease').directive('xlrFortifyOnDemandDipMapMetrics', function (xlWidgetUtils, $timeout) {

        function onModify($scope) {
            $timeout(function () {
                if (!$scope.readOnly && $scope.onChange) {
                    $scope.onChange();
                }
            });
        }

        return {
            restrict: 'A',
            scope: {
                ngModel: '=',
                metadata: '=',
                displayMode: '=?',
                readOnly: '=',
                onChange: '&'
            },
            templateUrl: function templateUrl(element, attrs) {
                return attrs.templateUrl || 'static/@project.version@/include/FortifyOnDemandSummaryTile/directives/xlr-fortify-on-demand-dip-map-metrics-directive.html';
            },
            require: ['?^form', 'ngModel'],
            link: function link(scope, element, attrs, ctrls) {
                var parentForm = ctrls[0];
                scope.isRequired = scope.metadata.required;

                if (!angular.isObject(scope.ngModel)) {
                    scope.ngModel = {};
                }
                scope.$set = scope.ngModel;

                scope.field = scope.metadata ? scope.metadata.field : undefined;

                if (!scope.field && !scope.readOnly) {
                    scope.$watch('$set', function (value) {
                        if (!value) return;
                        scope.ngModel = scope.$set;
                    }, true);
                }

                scope.remove = function (item) {
                    var deleted = delete scope.$set[item];
                    if (deleted) {
                        if (parentForm) {
                            parentForm.$setDirty();
                        }
                        onModify(scope);
                    }
                };
            },
            controller: function controller($scope) {
                $scope.newItem = '';

                $scope.$watch('readOnly', function () {
                    var readOnly = $scope.readOnly;
                    $scope.displayMode = readOnly ? 'visual' : 'creation';
                }, true);

                $scope.addItem = function ($event) {
                    if ($event && $event.isDefaultPrevented()) return;
                    //For Firefox and IE8+
                    //!$event For add button
                    if (!$event || $event.keyCode === 13 || $event.keyCode === 0 || $event.which === 13 || $event.which === 0) {
                        if ($event) {
                            $event.preventDefault();
                        }
                        $scope.error = '';
                        if ($scope.newItem === '') return;
                        $scope.newItem = '';
                        onModify($scope);
                    }
                };

                $scope.isEmpty = function () {
                    return Object.keys($scope.$set).length === 0;
                };

                this.getScope = function () {
                    return $scope;
                };
            }
        };
    });
})();
