/*
 * Copyright (c) 2018. All rights reserved.
 *
 * This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
 */
'use strict';

(function () {

    var FortifyOnDemandQueryTileViewController = function ($scope, FortifyOnDemandQueryService, XlrTileHelper) {
        var vm = this;

        vm.tileConfigurationIsPopulated = tileConfigurationIsPopulated;

        var tile;

        if ($scope.xlrDashboard) {
            // summary page
            vm.release = $scope.xlrDashboard.release;
            vm.tile = $scope.xlrTile.tile;
            if (vm.tile.properties == null) {
                vm.config = vm.tile.configurationProperties;
            } else {
                // new style since 7.0
                vm.config = vm.tile.properties;
            }
        }

        function tileConfigurationIsPopulated() {
            return !_.isEmpty(vm.config.fortifyOnDemandServer);
        }

        $scope.filterByKey = function (item) {
            return (item.key != 'Application Name' && item.key != 'Release' && item.key != 'Static Scan Date' && item.key != 'Dynamic Scan Date' && item.key != 'Mobile Scan Date');
        };

        function load(config) {
            if (tileConfigurationIsPopulated()) {
                vm.loading = true;
                FortifyOnDemandQueryService.executeQuery(vm.tile.id, config).then(
                    function (response) {
                        var fortifydata = response.data.data;
                        var lstData = [];
                        if (!fortifydata.error) {
                            for (var metric = 0; metric < Object.getOwnPropertyNames(fortifydata).length; metric++) {
                                var keyName = Object.getOwnPropertyNames(fortifydata)[metric];
                                var finalKeyName = vm.config.metrics.value[keyName];
                                switch (keyName) {
                                    case 'projectName':
                                        break;
                                    case 'projectVersion':
                                        break;
                                    case 'fortifyUrl':
                                        break;
                                    case 'applicationId':
                                        lstData.push({
                                            key: 'Application Name',
                                            value: fortifydata['projectName'],
                                            url: fortifydata['fortifyUrl'] + '/Applications/' + fortifydata['applicationId']
                                        });
                                        break;
                                    case 'releaseId':
                                        lstData.push({
                                            key: 'Release',
                                            value: fortifydata['projectVersion'],
                                            url: fortifydata['fortifyUrl'] + '/Releases/' + fortifydata['releaseId'] + '/Overview'
                                        });
                                        break;
                                    case 'staticScanDate':
                                        lstData.push({key: 'Static Scan Date', value: fortifydata[keyName]});
                                        break;
                                    case 'dynamicScanDate':
                                        lstData.push({key: 'Dynamic Scan Date', value: fortifydata[keyName]});
                                        break;
                                    case 'mobileScanDate':
                                        lstData.push({key: 'Mobile Scan Date', value: fortifydata[keyName]});
                                        break;
                                    default :
                                        lstData.push({
                                            key: finalKeyName,
                                            value: fortifydata[keyName]
                                        });

                                }

                            }
                            vm.result = {'lstData': lstData};
                        } else {
                            var error = ''
                            if (fortifydata.error instanceof Array) {
                                for (var index = 0; index < fortifydata.error.length; index++) {
                                    error = error + fortifydata.error[index]['msg']
                                }
                            } else {
                                error = fortifydata.error
                            }
                            vm.result = {'lstData': lstData, 'error': error};
                        }

                        $scope.xlrTile.title = tile.title + " : " + fortifydata['name'];
                    }
                ).finally(function () {
                    vm.loading = false;

                });
            }
        }


        function refresh() {
            load({params: {refresh: true}});
        }

        load();

        vm.refresh = refresh;
    };

    FortifyOnDemandQueryTileViewController.$inject = ['$scope', 'xlrelease.fortifyOnDemand.FortifyOnDemandQueryService', 'XlrTileHelper'];

    var FortifyOnDemandQueryService = function (Backend) {

        function executeQuery(tileId, config) {
            return Backend.get("tiles/" + tileId + "/data", config);
        }

        return {
            executeQuery: executeQuery
        };
    };

    FortifyOnDemandQueryService.$inject = ['Backend'];

    angular.module('xlrelease.fortifyOnDemand.tile', []);
    angular.module('xlrelease.fortifyOnDemand.tile').service('xlrelease.fortifyOnDemand.FortifyOnDemandQueryService', FortifyOnDemandQueryService);
    angular.module('xlrelease.fortifyOnDemand.tile').controller('fortifyOnDemand.FortifyOnDemandQueryTileViewController', FortifyOnDemandQueryTileViewController);
    angular.module('xlrelease').directive("addScrollBar", function () {
        return {
            link: function (scope, element) {
                element.context.parentElement.style.overflowY = "auto";
            }
        }
    });

})();

