#
# Copyright 2024 XEBIALABS
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

from dynatrace.DynatraceServer import DynatraceServer
from dynatrace.util import *

dynatraceServer = DynatraceServer(dynatraceServer)

validate_mandatory_field(monitorType, "Monitor Type not configured")
validate_mandatory_field(monitorId, "Monitor ID not configured")

response = dynatraceServer.triggerOnDemandExecutions(monitorId, failOnPerformanceThreshold, location, failOnSslWarning, executionCount)

if not response["triggered"]:
    for problem in response.get("triggeringProblemsDetails", []):
        error("An error occured while triggering executions : %s" % problem["cause"])
        

batchId = response["batchId"]
executionIds = {}  

for triggered in response["triggered"]:
    for execution in triggered["executions"]:
        executionIds[execution["executionId"]] = "RUNNING"

if waitForSuccessfulRun:
    task.schedule("dynatrace/triggerOnDemandExecutions-waitForSuccessfulRun.py")
    
else:
    batchStatus = "TRIGGERED"
    for triggered in response["triggered"]:
        for execution in triggered["executions"]:
            executionIds[execution["executionId"]] = "TRIGGERED"