package com.xebialabs.xlrelease.runner.docker.domain

import akka.actor.ActorRef
import com.xebialabs.xlrelease.domain.runner.{JobRunner, JobRunnerOps}
import com.xebialabs.xlrelease.runner.actors.JobRunnerActor.{AbortJob, StartRunner, StopRunner}
import com.xebialabs.xlrelease.runner.actors.JobRunnerActorFactory
import com.xebialabs.xlrelease.support.akka.spring.ScalaSpringAwareBean
import grizzled.slf4j.Logging

import scala.util.Try

trait DockerJobRunnerOps extends JobRunnerOps

object DockerJobRunnerOps extends DockerJobRunnerOps with ScalaSpringAwareBean with Logging {

  private lazy val jobRunnerActorFactory = springBean[JobRunnerActorFactory]
  private lazy val jobRunnerProcessingActor: ActorRef = jobRunnerActorFactory.create()


  override def start(runner: JobRunner): Unit = {
    Try(jobRunnerProcessingActor ! StartRunner(runner)).recover {
      case e: Throwable => logger.error("Unable to start job runner.", e)
    }
  }

  override def stop(runner: JobRunner): Unit = {
    Try {
      // TODO there should be a distinction between deleting a runner and stopping a runner
      //  (stopping it just moves it into a different state)
      jobRunnerProcessingActor ! StopRunner(runner.getId)
    }.recover {
      case e: Throwable => logger.error("Unable to stop job runner.", e)
    }
  }

  override def abortJob(runner: JobRunner, jobId: Long): Unit = {
    Try {
      jobRunnerProcessingActor ! AbortJob(runner.getId, jobId)
    }.recover {
      case e: Throwable => logger.error(s"Unable to abort job [$jobId]", e)
    }
  }

  override def accepts(runner: JobRunner): Boolean = {
    runner.isInstanceOf[DockerJobRunner]
  }
}
