package com.xebialabs.xlrelease.runner.actors

import akka.actor.ActorRef
import com.xebialabs.xlrelease.domain.runner.JobRunner
import com.xebialabs.xlrelease.runner.domain.{JobData, JobId}
import org.springframework.context.annotation.Primary
import org.springframework.stereotype.Component


trait JobExecutorActorFactory extends ActorFactory {
  type Order = Int
  type FactoryInput = Unit

  type StartMethod = PartialFunction[(JobRunner, JobData), ActorRef]
  type ResumeMethod = PartialFunction[JobId, ActorRef]
  type AbortMethod = PartialFunction[JobId, ActorRef]

  def start: StartMethod
  def resume: ResumeMethod
  def abort: AbortMethod
}

@Component
@Primary
class CompositeJobExecutorActorFactory(jobWorkerActorFactories: Array[JobExecutorActorFactory]) extends JobExecutorActorFactory {
  override def create: FactoryMethod = jobWorkerActorFactories.map(_.create).reduceLeft(_ orElse _)
  override def start: StartMethod = jobWorkerActorFactories.map(_.start).reduceLeft(_ orElse _)
  override def resume: ResumeMethod = jobWorkerActorFactories.map(_.resume).reduceLeft(_ orElse _)
  override def abort: AbortMethod = jobWorkerActorFactories.map(_.abort).reduceLeft(_ orElse _)
}
