package com.xebialabs.xlrelease.runner.docker.domain

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.deployit.plugin.api.validation.Range
import com.xebialabs.xlrelease.domain.runner.{Capability, JobRunner, JobRunnerOps, TagCapability}
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import java.util
import scala.beans.{BeanProperty, BooleanBeanProperty}
import scala.jdk.CollectionConverters._

@Metadata(label = "Docker job runner", description = "Runs Release jobs against configured docker server")
class DockerJobRunner extends JobRunner {

  type CapabilityType = Capability

  @BeanProperty
  @XLProperty(required = true, description = "Docker host. For example, tcp://docker-runner.digital.ai:2375")
  var host: String = _

  @BooleanBeanProperty
  @XLProperty(defaultValue = "true")
  var enabled: Boolean = true

  @XLProperty(isTransient = true, required = false, hidden = true, asContainment = true) // nested collections are marked 'asContainment'
  var capabilities: util.Set[CapabilityType] = new util.HashSet[CapabilityType]()

  @BeanProperty
  @XLProperty(asContainment = true) // nested collections are marked 'asContainment'
  var capabilityTags: util.Set[String] = new util.HashSet[String]()

  @BeanProperty
  @XLProperty(defaultValue = "4", description = "Capacity of the docker job runner to run containerized tasks.")
  @Range(minimum = 1, message = "Runner capacity must be greater than 0")
  var capacity: Integer = _

  override def start(): Unit = {
    JobRunnerOps.start(this)
  }

  override def stop(): Unit = {
    JobRunnerOps.stop(this)
  }

  override def abortJob(jobId: Long): Unit = {
    JobRunnerOps.abortJob(this, jobId)
  }

  override def getCapabilities(): util.Set[_ <: CapabilityType] = {
    capabilityTags.asScala.map(t => new TagCapability(t)).asJava
  }

  override def toString(): String = {
    val runnerCapabilities = getCapabilities().asScala.map(_.asString()).mkString(",")
    s"${this.getType.toString} [id=$getId, enabled=$enabled, capacity=$capacity, capabilities=[$runnerCapabilities]]"
  }

  override def isEncryptJobData(): Boolean = false
}

