/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.runner.docker.actors;

import akka.actor.Actor;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.WaitResponse;
import com.github.dockerjava.core.util.CompressArchiveUtil;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.runner.docker.actors.CommandSupport;
import com.xebialabs.xlrelease.runner.docker.actors.DockerJobExecutorActor;
import com.xebialabs.xlrelease.runner.docker.actors.DockerJobExecutorActor$CreateContainerInputContextCompleted$;
import com.xebialabs.xlrelease.runner.docker.actors.DockerJobExecutorActor$LogRetrievalCompleted$;
import com.xebialabs.xlrelease.runner.docker.actors.DockerJobExecutorActor$PullImageCompleted$;
import com.xebialabs.xlrelease.runner.docker.actors.DockerJobExecutorActor$RemoveContainerCompleted$;
import com.xebialabs.xlrelease.runner.docker.actors.DockerJobExecutorActor$StartContainerCompleted$;
import com.xebialabs.xlrelease.runner.docker.actors.DockerJobExecutorActor$TerminateJobCompleted$;
import com.xebialabs.xlrelease.runner.docker.actors.DockerLogHelper;
import com.xebialabs.xlrelease.runner.docker.actors.DockerService$;
import com.xebialabs.xlrelease.storage.domain.LogEntry;
import com.xebialabs.xlrelease.storage.domain.StorageEntry;
import com.xebialabs.xlrelease.storage.service.StorageService;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\t\ra!C\u000b\u0017!\u0003\r\taIAu\u0011\u0015Q\u0003\u0001\"\u0001,\u0011\u0015y\u0003A\"\u00011\u0011\u0015I\u0004A\"\u0001;\u0011\u0015\t\u0005A\"\u0001C\u0011\u0015Y\u0005Ab\u0001M\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000fAq!!\u0005\u0001\t\u0003\t\u0019\u0002C\u0004\u0002 \u0001!\t!!\t\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*!9\u0011\u0011\b\u0001\u0005\n\u0005m\u0002bBA&\u0001\u0011%\u0011Q\n\u0005\b\u0003[\u0002A\u0011AA8\u0011\u001d\t)\b\u0001C\u0001\u0003oBq!! \u0001\t\u0003\ty\bC\u0004\u0002\b\u0002!\t!!#\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0006bBA`\u0001\u0011%\u0011\u0011\u0019\u0005\b\u0003#\u0004A\u0011BAj\u00055!unY6feN+'O^5dK*\u0011q\u0003G\u0001\u0007C\u000e$xN]:\u000b\u0005eQ\u0012A\u00023pG.,'O\u0003\u0002\u001c9\u00051!/\u001e8oKJT!!\b\u0010\u0002\u0013ad'/\u001a7fCN,'BA\u0010!\u0003%AXMY5bY\u0006\u00147OC\u0001\"\u0003\r\u0019w.\\\u0002\u0001'\t\u0001A\u0005\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VMZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u00031\u0002\"!J\u0017\n\u000592#\u0001B+oSR\fqa]3mMJ+g-F\u00012!\t\u0011t'D\u00014\u0015\t!T'A\u0003bGR|'OC\u00017\u0003\u0011\t7n[1\n\u0005a\u001a$\u0001C!di>\u0014(+\u001a4\u0002\u0013ad'oQ8oM&<W#A\u001e\u0011\u0005qzT\"A\u001f\u000b\u0005yb\u0012AB2p]\u001aLw-\u0003\u0002A{\tI\u0001\f\u001c:D_:4\u0017nZ\u0001\u000fgR|'/Y4f'\u0016\u0014h/[2f+\u0005\u0019\u0005C\u0001#J\u001b\u0005)%B\u0001$H\u0003\u001d\u0019XM\u001d<jG\u0016T!\u0001\u0013\u000f\u0002\u000fM$xN]1hK&\u0011!*\u0012\u0002\u000f'R|'/Y4f'\u0016\u0014h/[2f\u00031!wnY6fe\u000ec\u0017.\u001a8u+\u0005i\u0005C\u0001(V\u001b\u0005y%B\u0001)R\u0003\r\t\u0007/\u001b\u0006\u0003%N\u000b!\u0002Z8dW\u0016\u0014(.\u0019<b\u0015\t!\u0006%\u0001\u0004hSRDWOY\u0005\u0003->\u0013A\u0002R8dW\u0016\u00148\t\\5f]R\f\u0011\u0002];mY&k\u0017mZ3\u0015\u000b1Jfm_?\t\u000bi3\u0001\u0019A.\u0002\rQ\f7o[%e!\ta6M\u0004\u0002^CB\u0011aLJ\u0007\u0002?*\u0011\u0001MI\u0001\u0007yI|w\u000e\u001e \n\u0005\t4\u0013A\u0002)sK\u0012,g-\u0003\u0002eK\n11\u000b\u001e:j]\u001eT!A\u0019\u0014\t\u000b\u001d4\u0001\u0019\u00015\u0002\u000b)|'-\u00133\u0011\u0005%DhB\u00016v\u001d\tY7O\u0004\u0002me:\u0011Q.\u001d\b\u0003]Bt!AX8\n\u0003\u0005J!a\b\u0011\n\u0005uq\u0012BA\u000e\u001d\u0013\t!($\u0001\u0004e_6\f\u0017N\\\u0005\u0003m^\fq\u0001]1dW\u0006<WM\u0003\u0002u5%\u0011\u0011P\u001f\u0002\u0006\u0015>\u0014\u0017\n\u001a\u0006\u0003m^DQ\u0001 \u0004A\u0002m\u000bq\u0001^1tW&kw\rC\u0003\u007f\r\u0001\u0007q0A\u0005mCN$8\t[;oWB\u0019Q%!\u0001\n\u0007\u0005\raE\u0001\u0003M_:<\u0017aD2sK\u0006$XmQ8oi\u0006Lg.\u001a:\u0015\u000f1\nI!a\u0003\u0002\u000e!)qm\u0002a\u0001Q\")Ap\u0002a\u00017\"1\u0011qB\u0004A\u0002m\u000bQbY8oi\u0006Lg.\u001a:OC6,\u0017aG2sK\u0006$XmQ8oi\u0006Lg.\u001a:J]B,HoQ8oi\u0016DH\u000fF\u0004-\u0003+\t9\"a\u0007\t\u000b\u001dD\u0001\u0019\u00015\t\r\u0005e\u0001\u00021\u0001\\\u0003-\u0019wN\u001c;bS:,'/\u00133\t\r\u0005u\u0001\u00021\u0001\\\u0003AIg\u000e];u\u0007>tG/\u001a=u\u0015N|g.\u0001\bti\u0006\u0014HoQ8oi\u0006Lg.\u001a:\u0015\u000b1\n\u0019#!\n\t\u000b\u001dL\u0001\u0019\u00015\t\r\u0005e\u0011\u00021\u0001\\\u0003M\u0019\u0017\r\u001d;ve\u0016\u001cuN\u001c;bS:,'\u000fT8h)-a\u00131FA\u0017\u0003_\t\t$!\u000e\t\u000biS\u0001\u0019A.\t\u000b\u001dT\u0001\u0019\u00015\t\r\u0005e!\u00021\u0001\\\u0011\u0019\t\u0019D\u0003a\u0001\u007f\u0006aA.Y:u\u0019><7\t[;oW\"1\u0011q\u0007\u0006A\u0002m\u000b\u0001\u0003\\1ti2{w\rV5nKN$\u0018-\u001c9\u0002\u0017\u0005$G\rT8h\u000b:$(/\u001f\u000b\u0004Y\u0005u\u0002bBA \u0017\u0001\u0007\u0011\u0011I\u0001\tY><WI\u001c;ssB!\u00111IA$\u001b\t\t)E\u0003\u0002u\u000f&!\u0011\u0011JA#\u0005!aunZ#oiJL\u0018a\u00037pO\u000e\u000bG\u000e\u001c2bG.$\u0002\"a\u0014\u0002h\u0005%\u00141\u000e\t\u0007\u0003#\n9&a\u0017\u000e\u0005\u0005M#bAA+\u001f\u0006)\u0011m]=oG&!\u0011\u0011LA*\u00059\u0011Vm];mi\u000e\u000bG\u000e\u001c2bG.\u0004B!!\u0018\u0002d5\u0011\u0011q\f\u0006\u0004\u0003Cz\u0015!B7pI\u0016d\u0017\u0002BA3\u0003?\u0012QA\u0012:b[\u0016DQA\u0017\u0007A\u0002mCQa\u001a\u0007A\u0002!DQA \u0007A\u0002}\f\u0001c^1ji\u001a{'oQ8oi\u0006Lg.\u001a:\u0015\u000b1\n\t(a\u001d\t\u000b\u001dl\u0001\u0019\u00015\t\r\u0005eQ\u00021\u0001\\\u0003q\u0019'/Z1uK\u000e{g\u000e^1j]\u0016\u0014x*\u001e;qkR\u001cuN\u001c;fqR$R\u0001LA=\u0003wBQa\u001a\bA\u0002!Da!!\u0007\u000f\u0001\u0004Y\u0016a\u0004:f[>4XmQ8oi\u0006Lg.\u001a:\u0015\u000f1\n\t)a!\u0002\u0006\")qm\u0004a\u0001Q\"1\u0011\u0011D\bA\u0002mCa!a\u0004\u0010\u0001\u0004Y\u0016A\u0005;fe6Lg.\u0019;f\u0007>tG/Y5oKJ$\u0012\u0002LAF\u0003\u001b\u000by)!%\t\u000b\u001d\u0004\u0002\u0019\u00015\t\r\u0005e\u0001\u00031\u0001\\\u0011\u0019\ty\u0001\u0005a\u00017\"9\u00111\u0013\tA\u0002\u0005U\u0015a\u0002;j[\u0016|W\u000f\u001e\t\u0004K\u0005]\u0015bAAMM\t\u0019\u0011J\u001c;\u0002\u001b!\fg\u000e\u001a7f\r\u0006LG.\u001e:f)\u001da\u0013qTAZ\u0003kCq!!)\u0012\u0001\u0004\t\u0019+\u0001\u0002fqB!\u0011QUAW\u001d\u0011\t9+a+\u000f\u0007y\u000bI+C\u0001(\u0013\t1h%\u0003\u0003\u00020\u0006E&!\u0003+ie><\u0018M\u00197f\u0015\t1h\u0005C\u0003h#\u0001\u0007\u0001\u000e\u0003\u0004\u00028F\u0001\raW\u0001\rKJ\u0014xN]'fgN\fw-Z\u0001\u0005a&tw\rF\u0002-\u0003{CQa\u001a\nA\u0002!\f1cZ3u\u0007>tG/Y5oKJ\u001c()\u001f(b[\u0016$B!a1\u0002PB1\u0011QUAc\u0003\u0013LA!a2\u00022\n\u00191+Z9\u0011\t\u0005u\u00131Z\u0005\u0005\u0003\u001b\fyFA\u0005D_:$\u0018-\u001b8fe\"1\u0011qB\nA\u0002m\u000b\u0011cZ3u\u0007>tG/Y5oKJ\u001cF/\u0019;f)\u0011\t).a:\u0011\t\u0005]\u00171\u001d\t\u0005\u00033\fy.\u0004\u0002\u0002\\*\u0019\u0011Q\\(\u0002\u000f\r|W.\\1oI&!\u0011\u0011]An\u0005aIen\u001d9fGR\u001cuN\u001c;bS:,'OU3ta>t7/Z\u0005\u0005\u0003K\fyN\u0001\bD_:$\u0018-\u001b8feN#\u0018\r^3\t\r\u0005eA\u00031\u0001\\%\u0019\tY/a<\u0002t\u001a1\u0011Q\u001e\u0001\u0001\u0003S\u0014A\u0002\u0010:fM&tW-\\3oiz\u00022!!=\u0001\u001b\u00051\"CBA{\u0003o\fiP\u0002\u0004\u0002n\u0002\u0001\u00111\u001f\t\u0004e\u0005e\u0018bAA~g\t)\u0011i\u0019;peB\u0019!'a@\n\u0007\t\u00051G\u0001\u0007BGR|'\u000fT8hO&tw\r")
public interface DockerService {
    public ActorRef selfRef();

    public XlrConfig xlrConfig();

    public StorageService storageService();

    public DockerClient dockerClient();

    public static /* synthetic */ void pullImage$(DockerService $this, String taskId, long jobId, String taskImg, long lastChunk) {
        $this.pullImage(taskId, jobId, taskImg, lastChunk);
    }

    default public void pullImage(String taskId, long jobId, String taskImg, long lastChunk) {
        try {
            this.dockerClient().pullImageCmd(taskImg).exec((ResultCallback)new CommandSupport(this, taskId, jobId, lastChunk, taskImg){
                private final DockerLogHelper logHelper;
                private boolean closed;
                private boolean com$xebialabs$xlrelease$runner$docker$actors$CommandSupport$$commandSubmitted;
                private final /* synthetic */ DockerService $outer;
                private final long jobId$1;
                private final String taskImg$1;

                public void submitCommand(DockerJobExecutorActor.DockerJobCommand dockerJobCommand) {
                    CommandSupport.submitCommand$(this, dockerJobCommand);
                }

                public boolean com$xebialabs$xlrelease$runner$docker$actors$CommandSupport$$commandSubmitted() {
                    return this.com$xebialabs$xlrelease$runner$docker$actors$CommandSupport$$commandSubmitted;
                }

                public void com$xebialabs$xlrelease$runner$docker$actors$CommandSupport$$commandSubmitted_$eq(boolean x$1) {
                    this.com$xebialabs$xlrelease$runner$docker$actors$CommandSupport$$commandSubmitted = x$1;
                }

                private /* synthetic */ void super$onComplete() {
                    super.onComplete();
                }

                private /* synthetic */ void super$onError(Throwable x$1) {
                    super.onError(x$1);
                }

                private DockerLogHelper logHelper() {
                    return this.logHelper;
                }

                private boolean closed() {
                    return this.closed;
                }

                private void closed_$eq(boolean x$1) {
                    this.closed = x$1;
                }

                private String buildPayload(PullResponseItem response) {
                    BoxedUnit boxedUnit;
                    StringBuilder builder = new StringBuilder();
                    Object object = response.getId() != null ? builder.append(new java.lang.StringBuilder(2).append(response.getId()).append(": ").toString()) : BoxedUnit.UNIT;
                    builder.append(new java.lang.StringBuilder(1).append(response.getStatus()).append(" ").toString());
                    if (response.getProgressDetail() != null && response.getProgressDetail().getCurrent() != null && response.getProgressDetail().getTotal() != null) {
                        String currentSize = FileUtils.byteCountToDisplaySize((long)Predef$.MODULE$.Long2long(response.getProgressDetail().getCurrent()));
                        String totalSize = FileUtils.byteCountToDisplaySize((long)Predef$.MODULE$.Long2long(response.getProgressDetail().getTotal()));
                        boxedUnit = builder.append(new java.lang.StringBuilder(3).append("[").append(currentSize).append("/").append(totalSize).append("]").toString());
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Object object2 = response.getErrorDetail() != null ? builder.append(new java.lang.StringBuilder(4).append("[").append(response.getErrorDetail().getCode()).append(": ").append(response.getErrorDetail().getMessage()).append("]").toString()) : BoxedUnit.UNIT;
                    builder.append(System.lineSeparator());
                    return builder.toString();
                }

                public void close() {
                    super.close();
                    if (!this.closed()) {
                        this.$outer.com$xebialabs$xlrelease$runner$docker$actors$DockerService$$addLogEntry(this.logHelper().flush());
                    }
                    this.closed_$eq(true);
                    this.logHelper().close();
                }

                public void onNext(PullResponseItem response) {
                    block0: {
                        super.onNext((Object)response);
                        if (this.closed()) break block0;
                        byte[] payload = this.buildPayload(response).getBytes();
                        this.logHelper().appendEntry(payload).foreach((Function1 & Serializable)logEntry -> {
                            $anon$1.$anonfun$onNext$1(this, logEntry);
                            return BoxedUnit.UNIT;
                        });
                    }
                }

                public void onComplete() {
                    Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.super$onComplete());
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable ex = failure.exception();
                        this.handlePullImageFailure(ex);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (try_ instanceof Success) {
                        this.submitCommand(new DockerJobExecutorActor.DockerOperationSuccess(this.jobId$1, DockerJobExecutorActor$PullImageCompleted$.MODULE$));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)try_);
                    }
                }

                public void onError(Throwable throwable) {
                    Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.super$onError(throwable));
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable ex = failure.exception();
                        this.handlePullImageFailure(ex);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (try_ instanceof Success) {
                        RuntimeException runtimeException;
                        Throwable throwable2 = throwable;
                        boolean bl = throwable2 instanceof ConnectionClosedException ? true : (throwable2 instanceof org.apache.http.ConnectionClosedException ? true : (throwable2 instanceof ConnectException ? true : throwable2 instanceof SocketException));
                        if (bl) {
                            this.submitCommand(new DockerJobExecutorActor.DockerOperationFailure(this.jobId$1, new DockerJobExecutorActor.ConnectionFailed(throwable2.getMessage())));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (throwable2 instanceof RuntimeException && (runtimeException = (RuntimeException)throwable2).getCause() instanceof ConnectException) {
                            this.submitCommand(new DockerJobExecutorActor.DockerOperationFailure(this.jobId$1, new DockerJobExecutorActor.ConnectionFailed(runtimeException.getCause().getMessage())));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.handlePullImageFailure(throwable);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)try_);
                    }
                }

                public ActorRef actorRef() {
                    return this.$outer.selfRef();
                }

                private void handlePullImageFailure(Throwable ex) {
                    String errorMessage = new java.lang.StringBuilder(36).append("Unable to pull image [").append(this.taskImg$1).append("] for jobId [").append(this.jobId$1).append("]").toString();
                    ((ActorLogging)this.$outer).log().error(ex, errorMessage);
                    this.submitCommand(new DockerJobExecutorActor.DockerOperationFailure(this.jobId$1, new DockerJobExecutorActor.OperationFailed(new java.lang.StringBuilder(2).append(errorMessage).append(": ").append(ex.getMessage()).toString())));
                }

                public static final /* synthetic */ void $anonfun$onNext$1($anon$1 $this, LogEntry logEntry) {
                    $this.$outer.com$xebialabs$xlrelease$runner$docker$actors$DockerService$$addLogEntry(logEntry);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.jobId$1 = jobId$1;
                    this.taskImg$1 = taskImg$1;
                    CommandSupport.$init$(this);
                    this.logHelper = new DockerLogHelper(taskId$1, jobId$1, lastChunk$1);
                    this.closed = false;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(com.xebialabs.xlrelease.runner.docker.actors.DockerService$$anon$1 ), $anonfun$onError$1(com.xebialabs.xlrelease.runner.docker.actors.DockerService$$anon$1 java.lang.Throwable ), $anonfun$onNext$1$adapted(com.xebialabs.xlrelease.runner.docker.actors.DockerService$$anon$1 com.xebialabs.xlrelease.storage.domain.LogEntry )}, serializedLambda);
                }
            });
        }
        catch (Throwable ex) {
            String errorMessage = new java.lang.StringBuilder(36).append("Unable to pull image [").append(taskImg).append("] for jobId [").append(jobId).append("]").toString();
            ((ActorLogging)this).log().error(ex, errorMessage);
            this.selfRef().$bang((Object)new DockerJobExecutorActor.DockerOperationFailure(jobId, new DockerJobExecutorActor.OperationFailed(new java.lang.StringBuilder(2).append(errorMessage).append(": ").append(ex.getMessage()).toString())), ((Actor)this).self());
        }
    }

    public static /* synthetic */ void createContainer$(DockerService $this, long jobId, String taskImg, String containerName) {
        $this.createContainer(jobId, taskImg, containerName);
    }

    default public void createContainer(long jobId, String taskImg, String containerName) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            scala.collection.immutable.Seq<Container> filteredContainers = this.getContainersByName(containerName);
            return filteredContainers.isEmpty() ? this.dockerClient().createContainerCmd(taskImg).withName(containerName).exec().getId() : ((Container)filteredContainers.head()).getId();
        });
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            String errorMessage = new java.lang.StringBuilder(41).append("Unable to create a container for jobId [").append(jobId).append("]").toString();
            this.handleFailure(ex, jobId, errorMessage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            String containerId = (String)success.value();
            this.selfRef().$bang((Object)new DockerJobExecutorActor.DockerOperationSuccess(jobId, new DockerJobExecutorActor.CreateContainerCompleted(containerId)), ((Actor)this).self());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static /* synthetic */ void createContainerInputContext$(DockerService $this, long jobId, String containerId, String inputContextJson) {
        $this.createContainerInputContext(jobId, containerId, inputContextJson);
    }

    default public void createContainerInputContext(long jobId, String containerId, String inputContextJson) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Path tempDir = Files.createTempDirectory("container-task", new FileAttribute[0]);
            Path file = Files.createFile(tempDir.resolve("input"), new FileAttribute[0]);
            FileUtils.writeStringToFile((File)file.toFile(), (String)inputContextJson, (Charset)StandardCharsets.UTF_8);
            Path temp = Files.createTempFile("", ".tar.gz", new FileAttribute[0]);
            CompressArchiveUtil.tar((Path)file, (Path)temp, (boolean)true, (boolean)false);
            return Using$.MODULE$.apply((Function0 & Serializable)() -> Files.newInputStream(temp, new OpenOption[0]), (Function1 & Serializable)uploadStream -> this.dockerClient().copyArchiveToContainerCmd(containerId).withTarInputStream(uploadStream).exec(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        });
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            String errorMessage = new java.lang.StringBuilder(75).append("Unable to create a container input context for jobId [").append(jobId).append("] with containerId [").append(containerId).append("]").toString();
            this.handleFailure(ex, jobId, errorMessage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            this.selfRef().$bang((Object)new DockerJobExecutorActor.DockerOperationSuccess(jobId, DockerJobExecutorActor$CreateContainerInputContextCompleted$.MODULE$), ((Actor)this).self());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static /* synthetic */ void startContainer$(DockerService $this, long jobId, String containerId) {
        $this.startContainer(jobId, containerId);
    }

    default public void startContainer(long jobId, String containerId) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            String string = this.getContainerState(containerId).getStatus().toLowerCase();
            String string2 = "created";
            return !(string != null ? !string.equals(string2) : string2 != null) ? this.dockerClient().startContainerCmd(containerId).exec() : BoxedUnit.UNIT;
        });
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            String errorMessage = new java.lang.StringBuilder(43).append("Unable to start a container [").append(containerId).append("] for jobId [").append(jobId).append("]").toString();
            this.handleFailure(ex, jobId, errorMessage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            this.selfRef().$bang((Object)new DockerJobExecutorActor.DockerOperationSuccess(jobId, DockerJobExecutorActor$StartContainerCompleted$.MODULE$), ((Actor)this).self());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static /* synthetic */ void captureContainerLog$(DockerService $this, String taskId, long jobId, String containerId, long lastLogChunk, String lastLogTimestamp) {
        $this.captureContainerLog(taskId, jobId, containerId, lastLogChunk, lastLogTimestamp);
    }

    default public void captureContainerLog(String taskId, long jobId, String containerId, long lastLogChunk, String lastLogTimestamp) {
        try {
            long timestamp = Instant.parse(lastLogTimestamp).getEpochSecond();
            LogContainerCmd cmd = this.dockerClient().logContainerCmd(containerId).withStdOut(Predef$.MODULE$.boolean2Boolean(true)).withStdErr(Predef$.MODULE$.boolean2Boolean(true)).withFollowStream(Predef$.MODULE$.boolean2Boolean(true)).withTimestamps(Predef$.MODULE$.boolean2Boolean(true)).withSince(Predef$.MODULE$.int2Integer((int)timestamp));
            cmd.exec(this.logCallback(taskId, jobId, lastLogChunk));
        }
        catch (Throwable ex) {
            String errorMessage = new java.lang.StringBuilder(55).append("Unable to capture logs for jobId [").append(jobId).append("] from containerId [").append(containerId).append("]").toString();
            ((ActorLogging)this).log().error(ex, errorMessage);
            this.selfRef().$bang((Object)new DockerJobExecutorActor.DockerOperationFailure(jobId, new DockerJobExecutorActor.OperationFailed(new java.lang.StringBuilder(2).append(errorMessage).append(": ").append(ex.getMessage()).toString())), ((Actor)this).self());
        }
    }

    public static /* synthetic */ void com$xebialabs$xlrelease$runner$docker$actors$DockerService$$addLogEntry$(DockerService $this, LogEntry logEntry) {
        $this.com$xebialabs$xlrelease$runner$docker$actors$DockerService$$addLogEntry(logEntry);
    }

    default public void com$xebialabs$xlrelease$runner$docker$actors$DockerService$$addLogEntry(LogEntry logEntry) {
        URI storedEntryUri = this.storageService().store((StorageEntry)logEntry);
        ((ActorLogging)this).log().debug(new java.lang.StringBuilder(35).append("Sending AddLogEntry for log entry: ").append(logEntry).toString());
        this.selfRef().$bang((Object)new DockerJobExecutorActor.AddLogEntry(logEntry, storedEntryUri), ((Actor)this).self());
    }

    private ResultCallback<Frame> logCallback(String taskId, long jobId, long lastChunk) {
        return new CommandSupport(this, taskId, jobId, lastChunk){
            private final DockerLogHelper logHelper;
            private boolean closed;
            private boolean com$xebialabs$xlrelease$runner$docker$actors$CommandSupport$$commandSubmitted;
            private final /* synthetic */ DockerService $outer;
            private final long jobId$2;

            public void submitCommand(DockerJobExecutorActor.DockerJobCommand dockerJobCommand) {
                CommandSupport.submitCommand$(this, dockerJobCommand);
            }

            public boolean com$xebialabs$xlrelease$runner$docker$actors$CommandSupport$$commandSubmitted() {
                return this.com$xebialabs$xlrelease$runner$docker$actors$CommandSupport$$commandSubmitted;
            }

            public void com$xebialabs$xlrelease$runner$docker$actors$CommandSupport$$commandSubmitted_$eq(boolean x$1) {
                this.com$xebialabs$xlrelease$runner$docker$actors$CommandSupport$$commandSubmitted = x$1;
            }

            private /* synthetic */ void super$onComplete() {
                super.onComplete();
            }

            private /* synthetic */ void super$onError(Throwable x$1) {
                super.onError(x$1);
            }

            private DockerLogHelper logHelper() {
                return this.logHelper;
            }

            private boolean closed() {
                return this.closed;
            }

            private void closed_$eq(boolean x$1) {
                this.closed = x$1;
            }

            public void onNext(Frame frame) {
                byte[] payload = frame.getPayload();
                if (!this.closed()) {
                    this.logHelper().appendEntry(payload).foreach((Function1 & Serializable)logEntry -> {
                        $anon$2.$anonfun$onNext$2(this, logEntry);
                        return BoxedUnit.UNIT;
                    });
                } else {
                    ((ActorLogging)this.$outer).log().error("appending log entry AFTER close");
                }
            }

            public void close() {
                super.close();
                if (!this.closed()) {
                    this.$outer.com$xebialabs$xlrelease$runner$docker$actors$DockerService$$addLogEntry(this.logHelper().flush());
                } else {
                    ((ActorLogging)this.$outer).log().error("appending log entry AFTER close");
                }
                this.closed_$eq(true);
                this.logHelper().close();
            }

            public void onComplete() {
                Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.super$onComplete());
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable ex = failure.exception();
                    this.handleLogRetrievalFailure(ex);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (try_ instanceof Success) {
                    this.submitCommand(new DockerJobExecutorActor.DockerOperationSuccess(this.jobId$2, DockerJobExecutorActor$LogRetrievalCompleted$.MODULE$));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)try_);
                }
            }

            public void onError(Throwable throwable) {
                Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.super$onError(throwable));
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    this.handleLogRetrievalFailure(exception);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (try_ instanceof Success) {
                    RuntimeException runtimeException;
                    Throwable throwable2 = throwable;
                    boolean bl = throwable2 instanceof ConnectionClosedException ? true : (throwable2 instanceof org.apache.http.ConnectionClosedException ? true : (throwable2 instanceof ConnectException ? true : throwable2 instanceof SocketException));
                    if (bl) {
                        this.submitCommand(new DockerJobExecutorActor.DockerOperationFailure(this.jobId$2, new DockerJobExecutorActor.ConnectionFailed(throwable2.getMessage())));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (throwable2 instanceof RuntimeException && (runtimeException = (RuntimeException)throwable2).getCause() instanceof ConnectException) {
                        this.submitCommand(new DockerJobExecutorActor.DockerOperationFailure(this.jobId$2, new DockerJobExecutorActor.ConnectionFailed(runtimeException.getCause().getMessage())));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.handleLogRetrievalFailure(throwable);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)try_);
                }
            }

            public ActorRef actorRef() {
                return this.$outer.selfRef();
            }

            private void handleLogRetrievalFailure(Throwable ex) {
                String errorMessage = new java.lang.StringBuilder(31).append("Unable to get logs for jobId [").append(this.jobId$2).append("]").toString();
                ((ActorLogging)this.$outer).log().error(ex, errorMessage);
                this.submitCommand(new DockerJobExecutorActor.DockerOperationFailure(this.jobId$2, new DockerJobExecutorActor.OperationFailed(new java.lang.StringBuilder(2).append(errorMessage).append(": ").append(ex.getMessage()).toString())));
            }

            public static final /* synthetic */ void $anonfun$onNext$2($anon$2 $this, LogEntry logEntry) {
                $this.$outer.com$xebialabs$xlrelease$runner$docker$actors$DockerService$$addLogEntry(logEntry);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.jobId$2 = jobId$2;
                CommandSupport.$init$(this);
                this.logHelper = new DockerLogHelper(taskId$2, jobId$2, lastChunk$2);
                this.closed = false;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$2(com.xebialabs.xlrelease.runner.docker.actors.DockerService$$anon$2 ), $anonfun$onError$2(com.xebialabs.xlrelease.runner.docker.actors.DockerService$$anon$2 java.lang.Throwable ), $anonfun$onNext$2$adapted(com.xebialabs.xlrelease.runner.docker.actors.DockerService$$anon$2 com.xebialabs.xlrelease.storage.domain.LogEntry )}, serializedLambda);
            }
        };
    }

    public static /* synthetic */ void waitForContainer$(DockerService $this, long jobId, String containerId) {
        $this.waitForContainer(jobId, containerId);
    }

    default public void waitForContainer(long jobId, String containerId) {
        try {
            this.dockerClient().waitContainerCmd(containerId).exec((ResultCallback)new CommandSupport(this, jobId, containerId){
                private int lastStatusCode;
                private boolean com$xebialabs$xlrelease$runner$docker$actors$CommandSupport$$commandSubmitted;
                private final /* synthetic */ DockerService $outer;
                private final long jobId$3;
                private final String containerId$3;

                public void submitCommand(DockerJobExecutorActor.DockerJobCommand dockerJobCommand) {
                    CommandSupport.submitCommand$(this, dockerJobCommand);
                }

                public boolean com$xebialabs$xlrelease$runner$docker$actors$CommandSupport$$commandSubmitted() {
                    return this.com$xebialabs$xlrelease$runner$docker$actors$CommandSupport$$commandSubmitted;
                }

                public void com$xebialabs$xlrelease$runner$docker$actors$CommandSupport$$commandSubmitted_$eq(boolean x$1) {
                    this.com$xebialabs$xlrelease$runner$docker$actors$CommandSupport$$commandSubmitted = x$1;
                }

                private /* synthetic */ void super$onComplete() {
                    super.onComplete();
                }

                private /* synthetic */ void super$onError(Throwable x$1) {
                    super.onError(x$1);
                }

                private int lastStatusCode() {
                    return this.lastStatusCode;
                }

                private void lastStatusCode_$eq(int x$1) {
                    this.lastStatusCode = x$1;
                }

                public void onNext(WaitResponse waitResponse) {
                    super.onNext(waitResponse);
                    this.lastStatusCode_$eq(Predef$.MODULE$.Integer2int(waitResponse.getStatusCode()));
                }

                public void onComplete() {
                    Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.super$onComplete());
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable ex = failure.exception();
                        this.handleWaitForContainerFailure(ex);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (try_ instanceof Success) {
                        this.submitCommand(new DockerJobExecutorActor.DockerOperationSuccess(this.jobId$3, new DockerJobExecutorActor.WaitForContainerCompleted(this.lastStatusCode())));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)try_);
                    }
                }

                public void onError(Throwable throwable) {
                    Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.super$onError(throwable));
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable ex = failure.exception();
                        this.handleWaitForContainerFailure(ex);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (try_ instanceof Success) {
                        RuntimeException runtimeException;
                        Throwable throwable2 = throwable;
                        boolean bl = throwable2 instanceof ConnectionClosedException ? true : (throwable2 instanceof org.apache.http.ConnectionClosedException ? true : (throwable2 instanceof ConnectException ? true : throwable2 instanceof SocketException));
                        if (bl) {
                            this.submitCommand(new DockerJobExecutorActor.DockerOperationFailure(this.jobId$3, new DockerJobExecutorActor.ConnectionFailed(throwable2.getMessage())));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (throwable2 instanceof RuntimeException && (runtimeException = (RuntimeException)throwable2).getCause() instanceof ConnectException) {
                            this.submitCommand(new DockerJobExecutorActor.DockerOperationFailure(this.jobId$3, new DockerJobExecutorActor.ConnectionFailed(runtimeException.getCause().getMessage())));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.handleWaitForContainerFailure(throwable);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)try_);
                    }
                }

                public ActorRef actorRef() {
                    return this.$outer.selfRef();
                }

                private void handleWaitForContainerFailure(Throwable ex) {
                    String errorMessage = new java.lang.StringBuilder(58).append("Unable to fetch status code from container [").append(this.containerId$3).append("] for jobId [").append(this.jobId$3).append("]").toString();
                    ((ActorLogging)this.$outer).log().error(ex, errorMessage);
                    this.submitCommand(new DockerJobExecutorActor.DockerOperationFailure(this.jobId$3, new DockerJobExecutorActor.OperationFailed(new java.lang.StringBuilder(2).append(errorMessage).append(": ").append(ex.getMessage()).toString())));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.jobId$3 = jobId$3;
                    this.containerId$3 = containerId$3;
                    CommandSupport.$init$(this);
                    this.lastStatusCode = -1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$3(com.xebialabs.xlrelease.runner.docker.actors.DockerService$$anon$3 ), $anonfun$onError$3(com.xebialabs.xlrelease.runner.docker.actors.DockerService$$anon$3 java.lang.Throwable )}, serializedLambda);
                }
            });
        }
        catch (Exception ex) {
            String errorMessage = new java.lang.StringBuilder(58).append("Unable to fetch status code from container [").append(containerId).append("] for jobId [").append(jobId).append("]").toString();
            ((ActorLogging)this).log().error((Throwable)ex, errorMessage);
            this.selfRef().$bang((Object)new DockerJobExecutorActor.DockerOperationFailure(jobId, new DockerJobExecutorActor.OperationFailed(new java.lang.StringBuilder(2).append(errorMessage).append(": ").append(ex.getMessage()).toString())), ((Actor)this).self());
        }
    }

    public static /* synthetic */ void createContainerOutputContext$(DockerService $this, long jobId, String containerId) {
        $this.createContainerOutputContext(jobId, containerId);
    }

    default public void createContainerOutputContext(long jobId, String containerId) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            InputStream resultStream = this.dockerClient().copyArchiveFromContainerCmd(containerId, "output").exec();
            return (Option)Using$.MODULE$.resource((Object)new TarArchiveInputStream(resultStream), (Function1 & Serializable)tar -> Option$.MODULE$.apply((Object)tar.getNextTarEntry()).withFilter((Function1 & Serializable)tarEntry -> BoxesRunTime.boxToBoolean((boolean)DockerService.$anonfun$createContainerOutputContext$3(tarEntry))).map((Function1 & Serializable)tarEntry -> StreamUtils.copyToString((InputStream)tar, (Charset)StandardCharsets.UTF_8)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        });
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            String errorMessage = new java.lang.StringBuilder(76).append("Unable to create a container output context for jobId [").append(jobId).append("] with containerId [").append(containerId).append("]").toString();
            this.handleFailure(ex, jobId, errorMessage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            Option os = (Option)success.value();
            Option option = os;
            if (option instanceof Some) {
                Some some = (Some)option;
                String res = (String)some.value();
                this.selfRef().$bang((Object)new DockerJobExecutorActor.DockerOperationSuccess(jobId, new DockerJobExecutorActor.CreateContainerOutputContextCompleted(res)), ((Actor)this).self());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.selfRef().$bang((Object)new DockerJobExecutorActor.DockerOperationFailure(jobId, new DockerJobExecutorActor.OperationFailed("No 'output' was read")), ((Actor)this).self());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static /* synthetic */ void removeContainer$(DockerService $this, long jobId, String containerId, String containerName) {
        $this.removeContainer(jobId, containerId, containerName);
    }

    default public void removeContainer(long jobId, String containerId, String containerName) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Void void_;
            String evaluatedId;
            scala.collection.immutable.Seq<Container> filteredContainers = this.getContainersByName(containerName);
            String string = evaluatedId = filteredContainers.isEmpty() ? containerId : ((Container)filteredContainers.head()).getId();
            if (Environment.isDevelopment() && this.xlrConfig().development().keepContainer()) {
                ((ActorLogging)this).log().info(new java.lang.StringBuilder(50).append("Skipping container [").append(containerName).append("] removal for development mode").toString());
                void_ = BoxedUnit.UNIT;
            } else {
                void_ = this.dockerClient().removeContainerCmd(evaluatedId).exec();
            }
            return void_;
        });
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            String errorMessage = new java.lang.StringBuilder(46).append("Unable to remove the container [").append(containerId).append("] for jobId [").append(jobId).append("]").toString();
            this.handleFailure(ex, jobId, errorMessage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            this.selfRef().$bang((Object)new DockerJobExecutorActor.DockerOperationSuccess(jobId, DockerJobExecutorActor$RemoveContainerCompleted$.MODULE$), ((Actor)this).self());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static /* synthetic */ void terminateContainer$(DockerService $this, long jobId, String containerId, String containerName, int timeout) {
        $this.terminateContainer(jobId, containerId, containerName, timeout);
    }

    default public void terminateContainer(long jobId, String containerId, String containerName, int timeout) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            scala.collection.immutable.Seq<Container> filteredContainers = this.getContainersByName(containerName);
            String evaluatedId = filteredContainers.isEmpty() ? containerId : ((Container)filteredContainers.head()).getId();
            return StringUtils.hasText((String)evaluatedId) && Predef$.MODULE$.Boolean2boolean(this.getContainerState(evaluatedId).getRunning()) ? this.dockerClient().stopContainerCmd(evaluatedId).withTimeout(Predef$.MODULE$.int2Integer(timeout)).exec() : BoxedUnit.UNIT;
        });
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            String errorMessage = new java.lang.StringBuilder(44).append("Unable to stop the container [").append(containerId).append("] for jobId [").append(jobId).append("]").toString();
            this.handleFailure(ex, jobId, errorMessage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            this.selfRef().$bang((Object)new DockerJobExecutorActor.DockerOperationSuccess(jobId, DockerJobExecutorActor$TerminateJobCompleted$.MODULE$), ((Actor)this).self());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    private void handleFailure(Throwable ex, long jobId, String errorMessage) {
        RuntimeException runtimeException;
        ((ActorLogging)this).log().error(ex, errorMessage);
        Throwable throwable = ex;
        boolean bl = throwable instanceof ConnectionClosedException ? true : (throwable instanceof org.apache.http.ConnectionClosedException ? true : (throwable instanceof ConnectException ? true : throwable instanceof SocketException));
        if (bl) {
            this.selfRef().$bang((Object)new DockerJobExecutorActor.DockerOperationFailure(jobId, new DockerJobExecutorActor.ConnectionFailed(throwable.getMessage())), ((Actor)this).self());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (throwable instanceof RuntimeException && (runtimeException = (RuntimeException)throwable).getCause() instanceof ConnectException) {
            this.selfRef().$bang((Object)new DockerJobExecutorActor.DockerOperationFailure(jobId, new DockerJobExecutorActor.ConnectionFailed(runtimeException.getCause().getMessage())), ((Actor)this).self());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.selfRef().$bang((Object)new DockerJobExecutorActor.DockerOperationFailure(jobId, new DockerJobExecutorActor.OperationFailed(new java.lang.StringBuilder(2).append(errorMessage).append(": ").append(ex.getMessage()).toString())), ((Actor)this).self());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static /* synthetic */ void ping$(DockerService $this, long jobId) {
        $this.ping(jobId);
    }

    default public void ping(long jobId) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (Void)this.dockerClient().pingCmd().exec());
        if (try_ instanceof Failure) {
            this.selfRef().$bang((Object)new DockerJobExecutorActor.DockerPingResult(jobId, false), ((Actor)this).self());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            this.selfRef().$bang((Object)new DockerJobExecutorActor.DockerPingResult(jobId, true), ((Actor)this).self());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    private scala.collection.immutable.Seq<Container> getContainersByName(String containerName) {
        return CollectionConverters$.MODULE$.ListHasAsScala((List)this.dockerClient().listContainersCmd().withShowAll(Predef$.MODULE$.boolean2Boolean(true)).withNameFilter((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{containerName}))).asJava()).exec()).asScala().toSeq();
    }

    private InspectContainerResponse.ContainerState getContainerState(String containerId) {
        return this.dockerClient().inspectContainerCmd(containerId).exec().getState();
    }

    public static /* synthetic */ boolean $anonfun$createContainerOutputContext$3(TarArchiveEntry tarEntry) {
        String string = tarEntry.getName();
        String string2 = "output";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static void $init$(DockerService $this) {
    }
}

