package com.xebialabs.xlrelease.runner.actors

import akka.actor.{Actor, ActorLogging, ActorRef}
import com.xebialabs.xlplatform.cluster.ClusterMode
import com.xebialabs.xlrelease.runner.actors.JobRunnerActor.{RunnerCommand, actorName}
import com.xebialabs.xlrelease.runner.domain._
import com.xebialabs.xlrelease.support.akka.spring.{SpringActor, SpringExtension}
import org.springframework.context.annotation.Profile

@Profile(Array(ClusterMode.STANDALONE))
@SpringActor
class JobRunnerProcessingActor extends Actor with ActorLogging {

  def createOrFind(runnerId: RunnerId, msg: AnyRef): ActorRef = {
    val childName = actorName(runnerId)
    context.child(childName).getOrElse {
      log.debug(s"JobRunnerProcessingActor - creating an actor tree for $runnerId (triggered by $msg)")
      SpringExtension.childActorOf(classOf[JobRunnerActor], childName)(context)
    }
  }

  override def receive: Receive = {
    case cmd: RunnerCommand =>
      log.debug(s"Received $cmd")
      createOrFind(cmd.runnerId, cmd) forward cmd
    case msg =>
      log.error(s"Can't process $msg")
  }

}
