/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.runner.docker.actors;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.cluster.sharding.ClusterSharding;
import akka.cluster.sharding.ClusterSharding$;
import akka.cluster.sharding.ClusterShardingSettings;
import akka.cluster.sharding.ClusterShardingSettings$;
import akka.cluster.sharding.ShardRegion;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.runner.docker.actors.DockerJobExecutorActor;
import com.xebialabs.xlrelease.runner.docker.actors.DockerJobExecutorActor$;
import com.xebialabs.xlrelease.runner.docker.actors.DockerJobExecutorActorFactory;
import com.xebialabs.xlrelease.runner.docker.actors.DockerJobExecutorProcessingActor;
import com.xebialabs.xlrelease.runner.domain.JobData;
import com.xebialabs.xlrelease.support.akka.spring.SpringExtension;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Profile(value={"full"})
@Component
@ScalaSignature(bytes="\u0006\u0005\u0005Ec\u0001\u0002\u0007\u000e\u0001iA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A!\u0007\u0001B\u0001B\u0003%1\u0007C\u0003>\u0001\u0011\u0005a\bC\u0003D\u0001\u0011%A\tC\u0003M\u0001\u0011\u0005Q\n\u0003\u0005[\u0001!\u0015\r\u0011\"\u0001\\\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015)\u0007\u0001\"\u0003g\u0011\u0015\u0019\b\u0001\"\u0003u\u0011\u0015A\b\u0001\"\u0001z\u0005\u0019\u001aE.^:uKJ,G\rR8dW\u0016\u0014(j\u001c2Fq\u0016\u001cW\u000f^8s\u0003\u000e$xN\u001d$bGR|'/\u001f\u0006\u0003\u001d=\ta!Y2u_J\u001c(B\u0001\t\u0012\u0003\u0019!wnY6fe*\u0011!cE\u0001\u0007eVtg.\u001a:\u000b\u0005Q)\u0012!\u0003=me\u0016dW-Y:f\u0015\t1r#A\u0005yK\nL\u0017\r\\1cg*\t\u0001$A\u0002d_6\u001c\u0001aE\u0002\u00017\u0005\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0007C\u0001\u0012$\u001b\u0005i\u0011B\u0001\u0013\u000e\u0005u!unY6fe*{'-\u0012=fGV$xN]!di>\u0014h)Y2u_JL\u0018!\u0003=me\u000e{gNZ5h!\t9#&D\u0001)\u0015\tI3#\u0001\u0004d_:4\u0017nZ\u0005\u0003W!\u0012\u0011\u0002\u00177s\u0007>tg-[4\u0002\u0019ML8\u000f^3n\u0011>dG-\u001a:\u0011\u00059\u0002T\"A\u0018\u000b\u00059\u0019\u0012BA\u00190\u0005E\t5\r^8s'f\u001cH/Z7I_2$WM]\u0001\u0010gB\u0014\u0018N\\4FqR,gn]5p]B\u0011AgO\u0007\u0002k)\u0011agN\u0001\u0007gB\u0014\u0018N\\4\u000b\u0005aJ\u0014\u0001B1lW\u0006T!AO\n\u0002\u000fM,\b\u000f]8si&\u0011A(\u000e\u0002\u0010'B\u0014\u0018N\\4FqR,gn]5p]\u00061A(\u001b8jiz\"Ba\u0010!B\u0005B\u0011!\u0005\u0001\u0005\u0006K\u0011\u0001\rA\n\u0005\u0006Y\u0011\u0001\r!\f\u0005\u0006e\u0011\u0001\raM\u0001\fC\u000e$xN]*zgR,W.F\u0001F!\t1%*D\u0001H\u0015\tA\u0015*A\u0003bGR|'OC\u00019\u0013\tYuIA\u0006BGR|'oU=ti\u0016l\u0017\u0001B5oSR$\u0012A\u0014\t\u0003\r>K!\u0001U$\u0003\u0011\u0005\u001bGo\u001c:SK\u001aD#A\u0002*\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016AC1o]>$\u0018\r^5p]*\tq+A\u0003kCZ\f\u00070\u0003\u0002Z)\ni\u0001k\\:u\u0007>t7\u000f\u001e:vGR\f1b\u001d5be\u0012\u0014VmZ5p]V\ta*\u0001\u0004de\u0016\fG/Z\u000b\u0002=B\u0011q\fY\u0007\u0002\u0001%\u0011\u0011M\u0019\u0002\u000e\r\u0006\u001cGo\u001c:z\u001b\u0016$\bn\u001c3\n\u0005\r$'\u0001D!di>\u0014h)Y2u_JL(B\u0001\b\u0012\u0003=)\u0007\u0010\u001e:bGR,e\u000e^5us&#W#A4\u0011\u0005!\u0004hBA5o\u001b\u0005Q'BA6m\u0003!\u0019\b.\u0019:eS:<'BA7J\u0003\u001d\u0019G.^:uKJL!a\u001c6\u0002\u0017MC\u0017M\u001d3SK\u001eLwN\\\u0005\u0003cJ\u0014q\"\u0012=ue\u0006\u001cG/\u00128uSRL\u0018\n\u001a\u0006\u0003_*\fa\"\u001a=ue\u0006\u001cGo\u00155be\u0012LE-F\u0001v!\tAg/\u0003\u0002xe\nqQ\t\u001f;sC\u000e$8\u000b[1sI&#\u0017aB:iCJ$\u0017\n\u001a\u000b\u0004u\u0006-\u0001cA>\u0002\u00069\u0019A0!\u0001\u0011\u0005ulR\"\u0001@\u000b\u0005}L\u0012A\u0002\u001fs_>$h(C\u0002\u0002\u0004u\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0004\u0003\u0013\u0011aa\u0015;sS:<'bAA\u0002;!9\u0011QB\u0006A\u0002\u0005=\u0011\u0001C3oi&$\u00180\u00133\u0011\t\u0005E\u0011q\u0004\b\u0004\u0003'qg\u0002BA\u000b\u0003;qA!a\u0006\u0002\u001c9\u0019Q0!\u0007\n\u0003aJ!!\\%\n\u0005-d\u0017bAA\u0011e\nAQI\u001c;jifLE\rK\u0002\u0001\u0003K\u0001B!a\n\u000265\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016TA!a\f\u00022\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u00024\u0005\u0019qN]4\n\t\u0005]\u0012\u0011\u0006\u0002\n\u0007>l\u0007o\u001c8f]RDs\u0001AA\u001e\u0003\u0013\nY\u0005\u0005\u0003\u0002>\u0005\u0015SBAA \u0015\r)\u0016\u0011\t\u0006\u0005\u0003\u0007\ni#A\u0004d_:$X\r\u001f;\n\t\u0005\u001d\u0013q\b\u0002\b!J|g-\u001b7f\u0003\u00151\u0018\r\\;fY\t\ti%\t\u0002\u0002P\u0005!a-\u001e7m\u0001")
public class ClusteredDockerJobExecutorActorFactory
implements DockerJobExecutorActorFactory {
    private ActorRef shardRegion;
    private final XlrConfig xlrConfig;
    private final ActorSystemHolder systemHolder;
    private final SpringExtension springExtension;
    private volatile boolean bitmap$0;

    @Override
    public PartialFunction<Tuple2<JobRunner, JobData>, ActorRef> start() {
        return DockerJobExecutorActorFactory.start$(this);
    }

    @Override
    public PartialFunction<Object, ActorRef> resume() {
        return DockerJobExecutorActorFactory.resume$(this);
    }

    @Override
    public PartialFunction<Object, ActorRef> abort() {
        return DockerJobExecutorActorFactory.abort$(this);
    }

    private ActorSystem actorSystem() {
        return this.systemHolder.actorSystem();
    }

    @PostConstruct
    public ActorRef init() {
        return this.shardRegion();
    }

    private ActorRef shardRegion$lzycompute() {
        ClusteredDockerJobExecutorActorFactory clusteredDockerJobExecutorActorFactory = this;
        synchronized (clusteredDockerJobExecutorActorFactory) {
            if (!this.bitmap$0) {
                ActorRef shardRegion;
                ClusterSharding sharding = (ClusterSharding)ClusterSharding$.MODULE$.apply(this.actorSystem());
                Config originalConfig = this.actorSystem().settings().config().getConfig("akka.cluster.sharding");
                Config shardingConfig = this.xlrConfig.xl().getConfig("job-runner.akka.cluster.sharding").withFallback((ConfigMergeable)originalConfig);
                ClusterShardingSettings shardingSettings = ClusterShardingSettings$.MODULE$.apply(shardingConfig);
                Props actorProps = this.springExtension.props(DockerJobExecutorProcessingActor.class, (Seq)Nil$.MODULE$);
                this.shardRegion = shardRegion = sharding.start("docker-job-executor", actorProps, shardingSettings, this.extractEntityId(), this.extractShardId());
                this.bitmap$0 = true;
            }
        }
        return this.shardRegion;
    }

    public ActorRef shardRegion() {
        return !this.bitmap$0 ? this.shardRegion$lzycompute() : this.shardRegion;
    }

    public PartialFunction<BoxedUnit, ActorRef> create() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusteredDockerJobExecutorActorFactory $outer;

            public final <A1 extends BoxedUnit, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                A1 A12 = A1;
                Object object = !(boxedUnit != null ? !boxedUnit.equals(A12) : A12 != null) ? this.$outer.shardRegion() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(BoxedUnit x1) {
                BoxedUnit boxedUnit = x1;
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                BoxedUnit boxedUnit3 = boxedUnit;
                boolean bl = !(boxedUnit2 != null ? !boxedUnit2.equals(boxedUnit3) : boxedUnit3 != null);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    private PartialFunction<Object, Tuple2<String, Object>> extractEntityId() {
        return new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof DockerJobExecutorActor.DockerJobCommand) {
                    DockerJobExecutorActor.DockerJobCommand dockerJobCommand = (DockerJobExecutorActor.DockerJobCommand)A1;
                    String entityId = DockerJobExecutorActor$.MODULE$.actorName(dockerJobCommand.jobId());
                    object = new Tuple2((Object)entityId, (Object)dockerJobCommand);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof DockerJobExecutorActor.DockerJobCommand;
                return bl;
            }
        };
    }

    private Function1<Object, String> extractShardId() {
        return (Function1 & Serializable)x0$1 -> {
            String string;
            Object object = x0$1;
            if (object instanceof DockerJobExecutorActor.DockerJobCommand) {
                DockerJobExecutorActor.DockerJobCommand dockerJobCommand = (DockerJobExecutorActor.DockerJobCommand)object;
                String entityId = DockerJobExecutorActor$.MODULE$.actorName(dockerJobCommand.jobId());
                string = this.shardId(entityId);
            } else if (object instanceof ShardRegion.StartEntity) {
                ShardRegion.StartEntity startEntity = (ShardRegion.StartEntity)object;
                String entityId = startEntity.entityId();
                string = this.shardId(entityId);
            } else {
                throw new MatchError(object);
            }
            return string;
        };
    }

    public String shardId(String entityId) {
        int numberOfShards = this.xlrConfig.sharding().numberOfReleaseShards();
        return Integer.toString(package$.MODULE$.abs(entityId.hashCode()) % numberOfShards);
    }

    public ClusteredDockerJobExecutorActorFactory(XlrConfig xlrConfig, ActorSystemHolder systemHolder, SpringExtension springExtension) {
        this.xlrConfig = xlrConfig;
        this.systemHolder = systemHolder;
        this.springExtension = springExtension;
        DockerJobExecutorActorFactory.$init$(this);
    }
}

