#
# Copyright 2018 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-external-backup-ingestion-strategy.json
#
# Do not edit this file manually!
#

from delphixpy.web.objects.IngestionStrategy import IngestionStrategy
from delphixpy import common

class __Undef(object):
    def __repr__(self):
        return "undef"

_UNDEFINED = __Undef()

class ExternalBackupIngestionStrategy(IngestionStrategy):
    """
    *(extends* :py:class:`delphixpy.web.vo.IngestionStrategy` *)* This link
    source has an external ingestion strategy that will pull in backups via
    ValidatedSync depending on the mode selected.
    """
    def __init__(self, undef_enabled=True):
        super(ExternalBackupIngestionStrategy, self).__init__()
        self._type = ("ExternalBackupIngestionStrategy", True)
        self._validated_sync_mode = (self.__undef__, True)

    API_VERSION = "1.10.0"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(ExternalBackupIngestionStrategy, cls).from_dict(data, dirty, undef_enabled)
        obj._validated_sync_mode = (data.get("validatedSyncMode", obj.__undef__), dirty)
        if obj._validated_sync_mode[0] is not None and obj._validated_sync_mode[0] is not obj.__undef__:
            assert isinstance(obj._validated_sync_mode[0], basestring), ("Expected one of [u'string'], but got %s" % type(obj._validated_sync_mode[0]))
            assert obj._validated_sync_mode[0] in [u'TRANSACTION_LOG', u'FULL_OR_DIFFERENTIAL', u'FULL'], "Expected enum [u'TRANSACTION_LOG', u'FULL_OR_DIFFERENTIAL', u'FULL'] but got %s" % obj._validated_sync_mode[0]
            common.validate_format(obj._validated_sync_mode[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(ExternalBackupIngestionStrategy, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "validated_sync_mode" == "type" or (self.validated_sync_mode is not self.__undef__ and (not (dirty and not self._validated_sync_mode[1]) or isinstance(self.validated_sync_mode, list) or belongs_to_parent)):
            dct["validatedSyncMode"] = dictify(self.validated_sync_mode)
        elif belongs_to_parent and self.validated_sync_mode is self.__undef__:
            dct["validatedSyncMode"] = "TRANSACTION_LOG"
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._validated_sync_mode = (self._validated_sync_mode[0], True)

    def is_dirty(self):
        return any([self._validated_sync_mode[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, ExternalBackupIngestionStrategy):
            return False
        return super(ExternalBackupIngestionStrategy, self).__eq__(other) and \
               self.validated_sync_mode == other.validated_sync_mode

    def __ne__(self, other):
        return not self.__eq__(other)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def validated_sync_mode(self):
        """
        *(default value: TRANSACTION_LOG)* Specifies the backup types
        ValidatedSync will use to synchronize the dSource with the source
        database. *(permitted values: TRANSACTION_LOG, FULL_OR_DIFFERENTIAL,
        FULL)*

        :rtype: ``basestring``
        """
        return self._validated_sync_mode[0]

    @validated_sync_mode.setter
    def validated_sync_mode(self, value):
        self._validated_sync_mode = (value, True)

