#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from delphixpy.web.selfservice import bookmark, branch
from delphix.lib.DelphixSession import DelphixSession
from delphix.lib.GetReferences import find_obj_name


def form_bookmark_path(template_name, container_name, branch_name, bookmark_name):
    if container_name:
        return "/%s/%s/%s/%s" % (template_name, container_name, branch_name, bookmark_name)
    else:
        return "/%s/%s" % (template_name, bookmark_name)

#Connect to the Delphix server
print("Connecting to the Delphix server...\n")
dlpx_obj = DelphixSession.create(server)
engine = dlpx_obj.server_session

print("Getting all engine bookmarks.\n")
js_bookmarks = bookmark.get_all(engine)

result = []
for js_bookmark in js_bookmarks:
    # pass bookmarks that do not match templateName
    if js_bookmark.template_name != templateName:
        continue
    add_it = False
    # check that all tags matches if a tagFilter is set
    if tagFilter is not None:
        if all(tag in js_bookmark.tags for tag in tagFilter):
            print("Found bookmark %s in template %s with tags %s.\n" % (str(js_bookmark.name),
                                                                        str(js_bookmark.template_name),
                                                                        str(js_bookmark.tags)))
            add_it = True
    else:
        print("Found bookmark %s in template %s.\n" % (str(js_bookmark.name), str(js_bookmark.templateName)))
        add_it = True

    if add_it:
        print("Finding the name of branch %s for bookmark %s.\n" %(str(js_bookmark.branch), str(js_bookmark.name)))
        branch_name = find_obj_name(engine, branch, js_bookmark.branch)
        print("Finding the bookmark path for bookmark %s.\n" % js_bookmark.name)
        key = form_bookmark_path(js_bookmark.template_name, js_bookmark.container_name, branch_name, js_bookmark.name)
        print("Found bookmark path %s.\n" % key)
        result.append(key)

bookmarks = result
