#
# Copyright 2018 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-support-contact.json
#
# Do not edit this file manually!
#

from delphixpy.web.objects.TypedObject import TypedObject
from delphixpy import common

class __Undef(object):
    def __repr__(self):
        return "undef"

_UNDEFINED = __Undef()

class SupportContact(TypedObject):
    """
    *(extends* :py:class:`delphixpy.web.vo.TypedObject` *)* A support telephone
    number mapped to a given country. May include text (e.g. 1-800-FOR-HELP).
    """
    def __init__(self, undef_enabled=True):
        super(SupportContact, self).__init__()
        self._type = ("SupportContact", True)
        self._country = (self.__undef__, True)
        self._phone_number = (self.__undef__, True)

    API_VERSION = "1.10.0"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(SupportContact, cls).from_dict(data, dirty, undef_enabled)
        if "country" not in data:
            raise ValueError("Missing required property \"country\".")
        obj._country = (data.get("country", obj.__undef__), dirty)
        if obj._country[0] is not None and obj._country[0] is not obj.__undef__:
            assert isinstance(obj._country[0], basestring), ("Expected one of [u'string'], but got %s" % type(obj._country[0]))
            assert obj._country[0] in [u'--', u'AF', u'AL', u'DZ', u'AS', u'AD', u'AO', u'AQ', u'AG', u'AR', u'AM', u'AW', u'AU', u'AT', u'AZ', u'BS', u'BH', u'BD', u'BB', u'BY', u'BE', u'BZ', u'BJ', u'BM', u'BT', u'BO', u'BA', u'BW', u'BV', u'BR', u'IO', u'BN', u'BG', u'BF', u'BI', u'KH', u'CM', u'CA', u'CV', u'KY', u'CF', u'TD', u'CL', u'CN', u'CX', u'CC', u'CO', u'KM', u'CG', u'CD', u'CK', u'CR', u'CI', u'HR', u'CU', u'CY', u'CZ', u'DK', u'DJ', u'DM', u'DO', u'EC', u'EG', u'SV', u'GQ', u'ER', u'EE', u'ET', u'FK', u'FO', u'FJ', u'FI', u'FR', u'GF', u'PF', u'TF', u'GA', u'GM', u'GE', u'DE', u'GH', u'GI', u'GR', u'GL', u'GD', u'GP', u'GU', u'GT', u'GN', u'GW', u'GY', u'HT', u'HM', u'HN', u'HK', u'HU', u'IS', u'IN', u'ID', u'IR', u'IQ', u'IE', u'IL', u'IT', u'JM', u'JP', u'JO', u'KZ', u'KE', u'KI', u'KP', u'KR', u'KW', u'KG', u'LA', u'LV', u'LB', u'LS', u'LR', u'LY', u'LI', u'LT', u'LU', u'MO', u'MK', u'MG', u'MW', u'MY', u'MV', u'ML', u'MT', u'MH', u'MQ', u'MR', u'MU', u'YT', u'MX', u'FM', u'MD', u'MC', u'MN', u'ME', u'MS', u'MA', u'MZ', u'MM', u'NA', u'NR', u'NP', u'NL', u'AN', u'NC', u'NZ', u'NI', u'NE', u'NG', u'NU', u'NF', u'MP', u'NO', u'OM', u'PK', u'PW', u'PS', u'PA', u'PG', u'PY', u'PE', u'PH', u'PN', u'PL', u'PT', u'PR', u'QA', u'RE', u'RO', u'RU', u'RW', u'SH', u'KN', u'LC', u'PM', u'VC', u'WS', u'SM', u'ST', u'SA', u'SN', u'RS', u'SC', u'SL', u'SG', u'SK', u'SI', u'SB', u'SO', u'ZA', u'GS', u'ES', u'LK', u'SD', u'SR', u'SJ', u'SZ', u'SE', u'CH', u'SY', u'TW', u'TJ', u'TZ', u'TH', u'TL', u'TG', u'TK', u'TO', u'TT', u'TN', u'TR', u'TM', u'TC', u'TV', u'UG', u'UA', u'AE', u'GB', u'US', u'UM', u'UY', u'UZ', u'VU', u'VE', u'VN', u'VG', u'VI', u'WF', u'EH', u'YE', u'ZM', u'ZW'], "Expected enum [u'--', u'AF', u'AL', u'DZ', u'AS', u'AD', u'AO', u'AQ', u'AG', u'AR', u'AM', u'AW', u'AU', u'AT', u'AZ', u'BS', u'BH', u'BD', u'BB', u'BY', u'BE', u'BZ', u'BJ', u'BM', u'BT', u'BO', u'BA', u'BW', u'BV', u'BR', u'IO', u'BN', u'BG', u'BF', u'BI', u'KH', u'CM', u'CA', u'CV', u'KY', u'CF', u'TD', u'CL', u'CN', u'CX', u'CC', u'CO', u'KM', u'CG', u'CD', u'CK', u'CR', u'CI', u'HR', u'CU', u'CY', u'CZ', u'DK', u'DJ', u'DM', u'DO', u'EC', u'EG', u'SV', u'GQ', u'ER', u'EE', u'ET', u'FK', u'FO', u'FJ', u'FI', u'FR', u'GF', u'PF', u'TF', u'GA', u'GM', u'GE', u'DE', u'GH', u'GI', u'GR', u'GL', u'GD', u'GP', u'GU', u'GT', u'GN', u'GW', u'GY', u'HT', u'HM', u'HN', u'HK', u'HU', u'IS', u'IN', u'ID', u'IR', u'IQ', u'IE', u'IL', u'IT', u'JM', u'JP', u'JO', u'KZ', u'KE', u'KI', u'KP', u'KR', u'KW', u'KG', u'LA', u'LV', u'LB', u'LS', u'LR', u'LY', u'LI', u'LT', u'LU', u'MO', u'MK', u'MG', u'MW', u'MY', u'MV', u'ML', u'MT', u'MH', u'MQ', u'MR', u'MU', u'YT', u'MX', u'FM', u'MD', u'MC', u'MN', u'ME', u'MS', u'MA', u'MZ', u'MM', u'NA', u'NR', u'NP', u'NL', u'AN', u'NC', u'NZ', u'NI', u'NE', u'NG', u'NU', u'NF', u'MP', u'NO', u'OM', u'PK', u'PW', u'PS', u'PA', u'PG', u'PY', u'PE', u'PH', u'PN', u'PL', u'PT', u'PR', u'QA', u'RE', u'RO', u'RU', u'RW', u'SH', u'KN', u'LC', u'PM', u'VC', u'WS', u'SM', u'ST', u'SA', u'SN', u'RS', u'SC', u'SL', u'SG', u'SK', u'SI', u'SB', u'SO', u'ZA', u'GS', u'ES', u'LK', u'SD', u'SR', u'SJ', u'SZ', u'SE', u'CH', u'SY', u'TW', u'TJ', u'TZ', u'TH', u'TL', u'TG', u'TK', u'TO', u'TT', u'TN', u'TR', u'TM', u'TC', u'TV', u'UG', u'UA', u'AE', u'GB', u'US', u'UM', u'UY', u'UZ', u'VU', u'VE', u'VN', u'VG', u'VI', u'WF', u'EH', u'YE', u'ZM', u'ZW'] but got %s" % obj._country[0]
            common.validate_format(obj._country[0], "None", None, None)
        obj._phone_number = (data.get("phoneNumber", obj.__undef__), dirty)
        if obj._phone_number[0] is not None and obj._phone_number[0] is not obj.__undef__:
            assert isinstance(obj._phone_number[0], basestring), ("Expected one of [u'string'], but got %s" % type(obj._phone_number[0]))
            common.validate_format(obj._phone_number[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(SupportContact, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "country" == "type" or (self.country is not self.__undef__ and (not (dirty and not self._country[1]) or isinstance(self.country, list) or belongs_to_parent)):
            dct["country"] = dictify(self.country)
        if "phone_number" == "type" or (self.phone_number is not self.__undef__ and (not (dirty and not self._phone_number[1]))):
            dct["phoneNumber"] = dictify(self.phone_number)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._country = (self._country[0], True)
        self._phone_number = (self._phone_number[0], True)

    def is_dirty(self):
        return any([self._country[1], self._phone_number[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, SupportContact):
            return False
        return super(SupportContact, self).__eq__(other) and \
               self.country == other.country and \
               self.phone_number == other.phone_number

    def __ne__(self, other):
        return not self.__eq__(other)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def country(self):
        """
        An ISO country code, as recognized by modern browsers for resolving
        locale. *(permitted values: --, AF, AL, DZ, AS, AD, AO, AQ, AG, AR, AM,
        AW, AU, AT, AZ, BS, BH, BD, BB, BY, BE, BZ, BJ, BM, BT, BO, BA, BW, BV,
        BR, IO, BN, BG, BF, BI, KH, CM, CA, CV, KY, CF, TD, CL, CN, CX, CC, CO,
        KM, CG, CD, CK, CR, CI, HR, CU, CY, CZ, DK, DJ, DM, DO, EC, EG, SV, GQ,
        ER, EE, ET, FK, FO, FJ, FI, FR, GF, PF, TF, GA, GM, GE, DE, GH, GI, GR,
        GL, GD, GP, GU, GT, GN, GW, GY, HT, HM, HN, HK, HU, IS, IN, ID, IR, IQ,
        IE, IL, IT, JM, JP, JO, KZ, KE, KI, KP, KR, KW, KG, LA, LV, LB, LS, LR,
        LY, LI, LT, LU, MO, MK, MG, MW, MY, MV, ML, MT, MH, MQ, MR, MU, YT, MX,
        FM, MD, MC, MN, ME, MS, MA, MZ, MM, NA, NR, NP, NL, AN, NC, NZ, NI, NE,
        NG, NU, NF, MP, NO, OM, PK, PW, PS, PA, PG, PY, PE, PH, PN, PL, PT, PR,
        QA, RE, RO, RU, RW, SH, KN, LC, PM, VC, WS, SM, ST, SA, SN, RS, SC, SL,
        SG, SK, SI, SB, SO, ZA, GS, ES, LK, SD, SR, SJ, SZ, SE, CH, SY, TW, TJ,
        TZ, TH, TL, TG, TK, TO, TT, TN, TR, TM, TC, TV, UG, UA, AE, GB, US, UM,
        UY, UZ, VU, VE, VN, VG, VI, WF, EH, YE, ZM, ZW)*

        :rtype: ``basestring``
        """
        return self._country[0]

    @country.setter
    def country(self, value):
        self._country = (value, True)

    @property
    def phone_number(self):
        """
        A telephone number, formatted in accordance with the norms of the
        associated country.

        :rtype: ``basestring``
        """
        return self._phone_number[0]

    @phone_number.setter
    def phone_number(self, value):
        self._phone_number = (value, True)

