#
# Copyright 2018 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-js-data-container-lock-parameters.json
#
# Do not edit this file manually!
#

from delphixpy.web.objects.TypedObject import TypedObject
from delphixpy import common

class __Undef(object):
    def __repr__(self):
        return "undef"

_UNDEFINED = __Undef()

class JSDataContainerLockParameters(TypedObject):
    """
    *(extends* :py:class:`delphixpy.web.vo.TypedObject` *)* The parameters used
    to lock a data container.
    """
    def __init__(self, undef_enabled=True):
        super(JSDataContainerLockParameters, self).__init__()
        self._type = ("JSDataContainerLockParameters", True)
        self._lock_user = (self.__undef__, True)

    API_VERSION = "1.10.0"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(JSDataContainerLockParameters, cls).from_dict(data, dirty, undef_enabled)
        if "lockUser" not in data:
            raise ValueError("Missing required property \"lockUser\".")
        obj._lock_user = (data.get("lockUser", obj.__undef__), dirty)
        if obj._lock_user[0] is not None and obj._lock_user[0] is not obj.__undef__:
            assert isinstance(obj._lock_user[0], basestring), ("Expected one of [u'string'], but got %s" % type(obj._lock_user[0]))
            common.validate_format(obj._lock_user[0], "objectReference", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(JSDataContainerLockParameters, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "lock_user" == "type" or (self.lock_user is not self.__undef__ and (not (dirty and not self._lock_user[1]) or isinstance(self.lock_user, list) or belongs_to_parent)):
            dct["lockUser"] = dictify(self.lock_user)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._lock_user = (self._lock_user[0], True)

    def is_dirty(self):
        return any([self._lock_user[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, JSDataContainerLockParameters):
            return False
        return super(JSDataContainerLockParameters, self).__eq__(other) and \
               self.lock_user == other.lock_user

    def __ne__(self, other):
        return not self.__eq__(other)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def lock_user(self):
        """
        A reference to the user object who locks the container.

        :rtype: ``basestring``
        """
        return self._lock_user[0]

    @lock_user.setter
    def lock_user(self, value):
        self._lock_user = (value, True)

