#
# Copyright 2018 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-analytics-iscsi-ops-datapoint-stream.json
#
# Do not edit this file manually!
#

from delphixpy.web.objects.DatapointStream import DatapointStream
from delphixpy import common

class __Undef(object):
    def __repr__(self):
        return "undef"

_UNDEFINED = __Undef()

class IScsiOpsDatapointStream(DatapointStream):
    """
    *(extends* :py:class:`delphixpy.web.vo.DatapointStream` *)* A stream of
    datapoints from a iSCSI_OPS analytics slice.
    """
    def __init__(self, undef_enabled=True):
        super(IScsiOpsDatapointStream, self).__init__()
        self._type = ("IScsiOpsDatapointStream", True)
        self._client = (self.__undef__, True)
        self._op = (self.__undef__, True)

    API_VERSION = "1.10.0"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(IScsiOpsDatapointStream, cls).from_dict(data, dirty, undef_enabled)
        obj._client = (data.get("client", obj.__undef__), dirty)
        if obj._client[0] is not None and obj._client[0] is not obj.__undef__:
            assert isinstance(obj._client[0], basestring), ("Expected one of [u'string'], but got %s" % type(obj._client[0]))
            common.validate_format(obj._client[0], "host", None, None)
        obj._op = (data.get("op", obj.__undef__), dirty)
        if obj._op[0] is not None and obj._op[0] is not obj.__undef__:
            assert isinstance(obj._op[0], basestring), ("Expected one of [u'string'], but got %s" % type(obj._op[0]))
            assert obj._op[0] in [u'read', u'write'], "Expected enum [u'read', u'write'] but got %s" % obj._op[0]
            common.validate_format(obj._op[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(IScsiOpsDatapointStream, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "client" == "type" or (self.client is not self.__undef__ and (not (dirty and not self._client[1]))):
            dct["client"] = dictify(self.client)
        if "op" == "type" or (self.op is not self.__undef__ and (not (dirty and not self._op[1]))):
            dct["op"] = dictify(self.op)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._client = (self._client[0], True)
        self._op = (self._op[0], True)

    def is_dirty(self):
        return any([self._client[1], self._op[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, IScsiOpsDatapointStream):
            return False
        return super(IScsiOpsDatapointStream, self).__eq__(other) and \
               self.client == other.client and \
               self.op == other.op

    def __ne__(self, other):
        return not self.__eq__(other)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def client(self):
        """
        Address of the client.

        :rtype: ``basestring``
        """
        return self._client[0]

    @client.setter
    def client(self, value):
        self._client = (value, True)

    @property
    def op(self):
        """
        I/O operation type. *(permitted values: read, write)*

        :rtype: ``basestring``
        """
        return self._op[0]

    @op.setter
    def op(self, value):
        self._op = (value, True)

