#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from delphix.lib.DxTimeflow import DxTimeflow
from delphixpy.web.database import database
from delphixpy.web.environment import environment
from delphixpy.web import database
from delphixpy.web import group
from delphixpy.web import repository
from delphixpy.web.vo import VirtualSourceOperations
from delphixpy.web.vo import OracleDatabaseContainer
from delphixpy.web.vo import OracleInstance
from delphixpy.web.vo import OracleProvisionParameters
from delphixpy.web.vo import OracleSIConfig
from delphixpy.web.vo import OracleVirtualSource
from delphix.lib.GetReferences import find_obj_by_name
from delphix.lib.DelphixSession import DelphixSession
from delphix.lib.GetReferences import find_dbrepo
from delphixpy.web.vo import MySQLProvisionParameters, MySQLDatabaseContainer, MySQLVirtualSource, MySQLServerConfig

from delphixpy.web.vo import MSSqlProvisionParameters
from delphixpy.web.vo import MSSqlDatabaseContainer
from delphixpy.web.vo import MSSqlVirtualSource
from delphixpy.web.vo import MSSqlSIConfig


def delphix_provision_oracle_database(engine):
    '''
    Create an Oracle SI VDB
    '''
    print("Finding the object information for dSource %s.\n" % source)
    container_obj = find_obj_by_name(engine, database, source)
    print("Finding the object information for dataset group %s.\n" % datasetGroup)
    vdb_group_obj = find_obj_by_name(engine, group, datasetGroup)
    vdb_params = OracleProvisionParameters()
    vdb_params.open_resetlogs = True
    vdb_params.container = OracleDatabaseContainer()
    vdb_params.container.group = vdb_group_obj.reference
    vdb_params.container.name = vdbName
    vdb_params.source = OracleVirtualSource()
    vdb_params.source.allow_auto_vdb_restart_on_host_reboot = False
    inst_name = vdbName
    vdb_params.source.mount_base = mountpoint
    vdb_params.source_config = OracleSIConfig()
    vdb_params.source.operations = VirtualSourceOperations()
    print("Finding the object information for environment %s.\n" % environmentName)
    environmentReference = (find_obj_by_name(engine, environment, environmentName)).reference
    print("Finding the Oracle installation.\n")
    vdb_repo = find_oracle_dbrepo(engine, environmentReference, environmentInstallPath)
    vdb_params.source_config.database_name = vdbName
    vdb_params.source_config.unique_name = vdbName
    vdb_params.source_config.instance = OracleInstance()
    vdb_params.source_config.instance.instance_name = inst_name
    vdb_params.source_config.instance.instance_number = 1
    vdb_params.source_config.repository = vdb_repo.reference
    print("Setting timestamp for provisioning to %s.\n" % timestamp)
    dx_timeflow_obj = DxTimeflow(engine)
    vdb_params.timeflow_point_parameters = \
        dx_timeflow_obj.set_timeflow_point(container_obj, timestamp)
    print("Provisioning database %s.\n" % vdbName)
    database.provision(engine, vdb_params)

def delphix_provision_mssql_database(engine):
    '''
    Create a MSSQL VDB
    '''
    print("Finding the object information for dSource %s.\n" % source)
    container_obj = find_obj_by_name(engine, database, source)
    print("Finding the object information for dataset group %s.\n" % datasetGroup)
    vdb_group_obj = find_obj_by_name(engine, group, datasetGroup)
    vdb_params = MSSqlProvisionParameters()
    vdb_params.container = MSSqlDatabaseContainer()
    vdb_params.container.group = vdb_group_obj.reference
    vdb_params.container.name = vdbName
    vdb_params.source = MSSqlVirtualSource()
    vdb_params.source.allow_auto_vdb_restart_on_host_reboot = False
    vdb_params.source_config = MSSqlSIConfig()
    vdb_params.source_config.database_name = vdbName
    print("Finding the object information for environment %s.\n" % environmentName)
    environmentReference = (find_obj_by_name(engine, environment, environmentName)).reference
    print("Finding the MSSql installation.\n")
    vdb_params.source_config.repository = find_dbrepo(engine, 'MSSqlInstance', environmentReference, environmentInstallPath).reference
    print("Setting timestamp for provisioning to %s.\n" % timestamp)
    dx_timeflow_obj = DxTimeflow(engine)
    vdb_params.timeflow_point_parameters = dx_timeflow_obj.set_timeflow_point(container_obj, timestamp)
    vdb_params.timeflow_point_parameters.container = \
        container_obj.reference
    print("Provisioning database %s.\n" % vdbName)
    database.provision(engine, vdb_params)


def delphix_provision_mysql_database(engine):
    '''
    Create a MySql VDB
    '''
    print("Finding the object information for dSource %s.\n" % source)
    container_obj = find_obj_by_name(engine, database, source)
    print("Finding the object information for dataset group %s.\n" % datasetGroup)
    vdb_group_obj = find_obj_by_name(engine, group, datasetGroup)
    vdb_params = MySQLProvisionParameters()
    vdb_params.container = MySQLDatabaseContainer()
    vdb_params.container.group = vdb_group_obj.reference
    vdb_params.container.name = vdbName
    vdb_params.source = MySQLVirtualSource()
    vdb_params.source.allow_auto_vdb_restart_on_host_reboot = False
    vdb_params.source.mount_base = mountpoint
    vdb_params.source_config = MySQLServerConfig()
    print("Finding the object information for environment %s.\n" % environmentName)
    environmentReference=(find_obj_by_name(engine, environment, environmentName)).reference
    print("Finding the MySql installation.\n")
    vdb_params.source_config.repository = find_dbrepo(engine, 'MySQLInstall', environmentReference, environmentInstallPath).reference
    vdb_params.source_config.port = int(mysqlPort)
    dx_timeflow_obj = DxTimeflow(engine)
    print("Setting timestamp for provisioning to %s.\n" % timestamp)
    vdb_params.timeflow_point_parameters=dx_timeflow_obj.set_timeflow_point(container_obj, timestamp)
    vdb_params.timeflow_point_parameters.container = container_obj.reference
    print('\n\n' + str(vdb_params) + '\n\n')
    print("Provisioning database %s.\n" % vdbName)
    database.provision(engine, vdb_params)


def find_oracle_dbrepo(engine, f_environment_ref, f_install_path):
    '''
    Function to find database repository objects by environment reference and
    install path, and return the object's reference as a string
    You might use this function to find Oracle and PostGreSQL database repos.
    '''
    for obj in repository.get_all(engine, environment=f_environment_ref):
        if (obj.installation_home == f_install_path):
            print('Found a repository match: %s.\n' % str(obj.reference))
            return obj
    print('No repository match found.')


# Connect to the Delphix server
print("Connecting to the Delphix server...\n")
engine = DelphixSession.create(server).server_session
if databaseType == "Oracle":
    delphix_provision_oracle_database(engine)
elif databaseType == "Microsoft SQL Server":
    delphix_provision_mssql_database(engine)
elif databaseType == "MySql":
    delphix_provision_mysql_database(engine)
