#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from delphixpy.web.selfservice import bookmark, template, container
from delphix.lib.DelphixSession import DelphixSession
from delphix.lib.GetReferences import find_obj_by_name
from delphixpy.web.vo import JSBookmarkCreateParameters, JSBookmark
from delphixpy.exceptions import RequestError, HttpError

# Connect to the Delphix server
print("Connecting to the Delphix server...\n")
dlpx_obj = DelphixSession.create(server)
engine = dlpx_obj.server_session

engine_name = server['url']
js_bookmark_params = JSBookmarkCreateParameters()
# Find the self service container/ template in which to create the bookmark
if not containerName:
    print("Finding the self service template %s.\n" % templateName)
    (source_layout_ref, branch_ref) = find_obj_by_name(
        engine, template, templateName, True)
else:
    print("Finding the self service container %s.\n" % containerName)
    (source_layout_ref, branch_ref) = find_obj_by_name(
        engine, container, containerName, True)
# Configure the bookmark parameters
js_bookmark_params.bookmark = JSBookmark()
js_bookmark_params.bookmark.name = bookmarkName
js_bookmark_params.bookmark.branch = branch_ref
if tags:
    js_bookmark_params.bookmark.tags = tags
if description:
    js_bookmark_params.bookmark.description = description
js_bookmark_params.timeline_point_parameters = {
        'sourceDataLayout': source_layout_ref, 'type':
            'JSTimelinePointLatestTimeInput'}
# Try to create the bookmark using delphixpy
try:
    print("Attempting to create the bookmark %s.\n" % bookmarkName)
    bookmark.create(engine, js_bookmark_params)
    print('\nJS Bookmark {} was created successfully.'.format(
        bookmarkName))

except (Exception, RequestError, HttpError) as e:
    print('\nThe bookmark {} was not created.'.format(bookmarkName))
    raise e