#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from delphixpy.delphix_engine import DelphixEngine


VERSION = 'v.0.2.09'

class DelphixSession(object):
    """
    Class to get the configuration and returns an Delphix authentication
    object
    """

    def __init__(self):
        self.server_session = None
        self.dlpx_engines = {}
        self.jobs = {}

    def __getitem__(self, key):
        return self.data[key]

    @staticmethod
    def create(config):
        sess = DelphixSession()
        sess.dlpx_engines[config['url']] = config
        sess.serversess(config['url'], config['username'], config['password'])
        return sess

    def serversess(self, f_engine_address, f_engine_username,
                   f_engine_password, f_engine_namespace='DOMAIN'):
        """
        Method to setup the session with the Virtualization Engine

        f_engine_address: The Virtualization Engine's address (IP/DNS Name)
        f_engine_username: Username to authenticate
        f_engine_password: User's password
        f_engine_namespace: Namespace to use for this session. Default: DOMAIN
        """

#        if use_https:
#            if hasattr(ssl, '_create_unverified_context'):
#                ssl._create_default_https_context = \
#                    ssl._create_unverified_context

        if f_engine_password:
            self.server_session = DelphixEngine(f_engine_address,
                                                f_engine_username,
                                                f_engine_password,
                                                f_engine_namespace)
        elif f_engine_password is None:
            self.server_session = DelphixEngine(f_engine_address,
                                                f_engine_username,
                                                None, f_engine_namespace)