#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from delphixpy.web.vo import RollbackParameters, OracleRollbackParameters
from delphix.lib.DxTimeflow import DxTimeflow
from delphixpy.web import database
from delphix.lib.DelphixSession import DelphixSession
from delphix.lib.GetReferences import find_obj_by_name


# Connect to the Delphix server
print("Connecting to the Delphix server...\n")
dlpx_obj = DelphixSession.create(server)
engine = dlpx_obj.server_session

dx_timeflow_obj = DxTimeflow(engine)
print("Finding database with name %s.\n" % databaseName)
container_obj = find_obj_by_name(engine, database, databaseName)
container_obj_ref = container_obj.reference
print("Found reference %s for name %s\n" % (container_obj_ref, databaseName))
if str(container_obj.reference).startswith("ORACLE"):
    rewind_params = OracleRollbackParameters()
else:
    rewind_params = RollbackParameters()
print("Locating timestamp %s.\n" % timestamp)
rewind_params.timeflow_point_parameters = dx_timeflow_obj.set_timeflow_point(container_obj, timestamp)
print("Rolling back the database to timestamp %s.\n" % str(timestamp))
database.rollback(engine, container_obj_ref, rewind_params)