#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from delphixpy.web.vo import OracleRefreshParameters, RefreshParameters
from delphix.lib.DxTimeflow import DxTimeflow
from delphixpy.web import database
from delphix.lib.DelphixSession import DelphixSession
from delphix.lib.GetReferences import find_obj_by_name

# Connect to the Delphix server
print("Connecting to the Delphix server...\n")
dlpx_obj = DelphixSession.create(server)
engine = dlpx_obj.server_session

dx_timeflow_obj = DxTimeflow(engine)
container_obj = find_obj_by_name(engine, database,
                                     databaseName)
container_obj_ref = container_obj.reference
source_db = database.get(engine, container_obj.provision_container)
print("Found reference %s for name %s\n" % (container_obj_ref, databaseName))
# If the vdb is a Oracle type, we need to use a
# OracleRefreshParameters
if str(container_obj_ref).startswith("ORACLE"):
    refresh_params = OracleRefreshParameters()
else:
    refresh_params = RefreshParameters()
refresh_params.timeflow_point_parameters = \
    dx_timeflow_obj.set_timeflow_point(source_db)
print(str(refresh_params))
print("Refreshing the database\n")
# Sync it
database.refresh(engine, container_obj_ref,
                 refresh_params)
