#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from delphixpy.web.selfservice import bookmark
from delphix.lib.DelphixSession import DelphixSession
from delphix.lib.GetReferences import find_bookmark_ref


def split_bookmark_path(bookmark_path):
    """
    object paths are of the form:
    /<template_name>/<container_name>/<branch_name>/<bookmark_name> for container bookmarks
    or
    /<template_name>/<bookmark_name> for template bookmarks
    """
    if bookmark_path[0] != '/':
        raise Exception("'%s' is not a valid absolute path. It must start with '/'" % bookmark_path)
    path_el = bookmark_path[1:].split('/')

    result = {}
    # parse the bookmark path into template, container, branch, and bookmark names
    if len(path_el) > 2:
        result['template_name']  = path_el[0]
        result['container_name'] = path_el[1]
        result['branch_name']    = path_el[2]
        result['bookmark_name']  = path_el[3]
    else:
        result['template_name']  = path_el[0]
        result['container_name'] = None
        result['branch_name']    = None
        result['bookmark_name']  = path_el[1]

    return result

# Connect to the Delphix server
print("Connecting to the Delphix server...\n")
dlpx_obj = DelphixSession.create(server)
engine = dlpx_obj.server_session

for bookmark_path in bookmarkPath:
    # Delete all bookmarks in the bookmarkPath list of strings
    print("Parsing the bookmark path.\n")
    path = split_bookmark_path(bookmark_path)
    print("Finding the reference for bookmark %s.\n" % path['bookmark_name'])
    bookmark_ref = find_bookmark_ref(engine, path['template_name'], path['container_name'], path['branch_name'], path['bookmark_name'])
    print('\nDeleting bookmark {}.\n'.format(bookmark_path))
    bookmark.delete(engine, bookmark_ref)
    print('\nBookmark {} was deleted successfully.\n'.format(bookmark_path))
