#
# Copyright 2018 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-oracle-custom-env-var-rac-pair.json
#
# Do not edit this file manually!
#

from delphixpy.web.objects.OracleCustomEnvVarPair import OracleCustomEnvVarPair
from delphixpy import common

class __Undef(object):
    def __repr__(self):
        return "undef"

_UNDEFINED = __Undef()

class OracleCustomEnvVarRACPair(OracleCustomEnvVarPair):
    """
    *(extends* :py:class:`delphixpy.web.vo.OracleCustomEnvVarPair` *)* Dictates
    a single environment variable name and value to be set when the Delphix
    Engine administers an Oracle virtual database. For a RAC environment, the
    cluster node where the target pair is valid must also be specified.
    """
    def __init__(self, undef_enabled=True):
        super(OracleCustomEnvVarRACPair, self).__init__()
        self._type = ("OracleCustomEnvVarRACPair", True)
        self._cluster_node = (self.__undef__, True)

    API_VERSION = "1.10.0"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(OracleCustomEnvVarRACPair, cls).from_dict(data, dirty, undef_enabled)
        if "clusterNode" not in data:
            raise ValueError("Missing required property \"clusterNode\".")
        obj._cluster_node = (data.get("clusterNode", obj.__undef__), dirty)
        if obj._cluster_node[0] is not None and obj._cluster_node[0] is not obj.__undef__:
            assert isinstance(obj._cluster_node[0], basestring), ("Expected one of [u'string'], but got %s" % type(obj._cluster_node[0]))
            common.validate_format(obj._cluster_node[0], "objectReference", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(OracleCustomEnvVarRACPair, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "cluster_node" == "type" or (self.cluster_node is not self.__undef__ and (not (dirty and not self._cluster_node[1]) or isinstance(self.cluster_node, list) or belongs_to_parent)):
            dct["clusterNode"] = dictify(self.cluster_node)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._cluster_node = (self._cluster_node[0], True)

    def is_dirty(self):
        return any([self._cluster_node[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, OracleCustomEnvVarRACPair):
            return False
        return super(OracleCustomEnvVarRACPair, self).__eq__(other) and \
               self.cluster_node == other.cluster_node

    def __ne__(self, other):
        return not self.__eq__(other)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def cluster_node(self):
        """
        The cluster node on which the environment variable is relevant.

        :rtype: ``basestring``
        """
        return self._cluster_node[0]

    @cluster_node.setter
    def cluster_node(self, value):
        self._cluster_node = (value, True)

